<?php
/* Ulyxex version 1.4.4 *****************/
/****************************************/
/* clean all sessions 					*/
/* session always before header			*/
session_start();
/* erase all sessions					*/
$_SESSION = array();
/* delete cookies						*/
if (isset($_COOKIE[session_name()])){
	setcookie(session_name(), '', time()-42000, '/');
}
/* destroy sessions						*/
session_destroy();
/****************************************/
/* required								*/
require_once("config.php");
require_once("pages/core/ulyxex.php");
require_once("pages/core/html.php");
require_once("pages/core/translate.php");
/****************************************/
/* page elements						*/
$h = new Html();
$t = new Translate();
$css = $h->css("css/view_style.css","external");
$meta = $h->meta("Content-Type","text/html; charset=UTF-8");
$title = $h->title("logout");
$head = $h->head($meta.$css.$title);

$topPage = $h->h1($t->w("logout done"));

$bottomPage = $h->ulyxCredits();
/****************************************/
/* page data							*/	
$root_url = $h->root_url();
$data = $h->h3($h->ahref("index.php","go to ".$root_url));
/****************************************/
/* show									*/
$body = $h->body($topPage.$data.$bottomPage);
$page = $h->html($head.$body);

echo $page;
?>