<?php
/* Ulyxex version 1.4.3 *****************/
class Html {
	function __construct(){
		$this->extUploadAllowed = array("7z","aac","ai","aif","aifc","aiff","arj","asf","asr","asx","au","avi","bin","bmp","cda","dcr","doc","dot","eps","flv","gif","gz","hqx","html","ico","jfif","jpe","jpeg","jpg","m4a","m4b","m4v","mid","mov","mp2","mp3","mp4","mpa","mpe","mpeg","mpg","odb","odc","odf","odg","odi","odm","odp","ods","odt","ogg","pdf","png","pps","ppt","ps","psd","ra","ram","rar","rm","rmi","rtf","sea","sit","sla","stc","std","sti","stw","swf","sxc","sxd","sxg","sxi","sxm","sxw","tar","tgz","tif","tiff","torrent","txt","vcf","wav","wcm","wdb","webm","wks","wma","wmf","wmv","wps","wri","wrl","wrz","xaf","xbm","xla","xlc","xlm","xls","xlt","xlw","xml","xof","xpm","xsd","xsl","xwd","xspf","zip","pict");
	}
	public function html($val=null,$params=null){
		// ulyxex default use html version 5
		return $this->html5($val,$params);
		// return $this->html4($val,$params);
		// return $this->xhtml1($val,$params);
	}
	public function html5($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "<!DOCTYPE HTML>\n";
		$result .= "<html".$params.">";
		$result .= $val."\n</html>";
		return $result;
	}
	public function html4($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
		$result .= "<html".$params.">";
		$result .= $val."\n</html>";
		return $result;
	}
	public function xhtml1($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?".">\n";
		$result .= "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/html51/DTD/html51-transitional.dtd\">\n";
		$result .= "<html xmlns=\"http://www.w3.org/1999/xhtml\"".$params.">";
		$result .= $val."\n</html>\n";
		return $result;
	}
	public function error404(){
		$head = $this->title("404 Not Found");
		$body = $this->h1("Not Found").$this->p("The requested URL ".$_SERVER['PHP_SELF']." was not found on this server.");
		return $this->html($this->head($head).$this->body($body));
	}
	public function alertPage($content="") {
		$head = $this->title("Alert !");
		$body = $this->p("Alert !","style='color:red'");
		$body .= $this->h1($content,"style='color:red'");
		return $this->html($this->head($head).$this->body($body));
	}
	function tag($tag=null,$val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<".$tag.$params.">".$val."</".$tag.">";
	}
	public function body($val=null,$params=null){
		if ($params){$params = " ".$params;}
		return $this->tag("body",$val,$params);
	}
	public function head($val=null){
		return $this->tag("head",$val);
	}
	public function meta($action=null,$content=null,$type="http-equiv"){
		if ($action) return "\n<meta ".$type."=\"".$action."\" content=\"".$content."\" />";
	}
	public function title($val=null){
		return $this->tag("title",$val);
	}
	public function ico($val=null){
		if ($val && file_exists($val)) return "<link rel=\"icon\" type=\"image/png\" href=\"".$val."\" />";
	}
	public function header($val=null,$params=null){
		return $this->tag("header",$val,$params);
	}
	public function article($val=null,$params=null){
		return $this->tag("article",$val,$params);
	}
	public function aside($val=null,$params=null){
		return $this->tag("aside",$val,$params);
	}
	public function mark($val=null,$params=null){
		return $this->tag("mark",$val,$params);
	}
	public function nav($val=null,$params=null){
		return $this->tag("nav",$val,$params);
	}
	public function footer($val=null,$params=null){
		return $this->tag("footer",$val,$params);
	}
	public function h1($val=null,$params=null){
		return $this->tag("h1",$val,$params);
	}
	public function h2($val=null,$params=null){
		return $this->tag("h2",$val,$params);
	}
	public function h3($val=null,$params=null){
		return $this->tag("h3",$val,$params);
	}
	public function p($val=null,$params=null){
		return $this->tag("p",$val,$params);
	}
	public function b($val=null,$params=null){
		return $this->tag("strong",$val,$params);
	}
	public function pre($val=null,$params=null){
		return $this->tag("pre",$val,$params);
	}
	public function div($val=null,$params=null){
		return $this->tag("div",$val,$params);
	}
	public function span($val=null,$params=null){
		return $this->tag("span",$val,$params);
	}
	public function color($val="",$color="black") {
		if ($val) return "<span style=\"color:".$color."\">".$val."</span>";
	}
	public function ol($val=null,$params=null){
		return $this->tag("ol",$val,$params);
	}
	public function ul($val=null,$params=null){
		return $this->tag("ul",$val,$params);
	}
	public function li($val=null,$params=null){
		return $this->tag("li",$val,$params);
	}
	public function comment($val=null){
		if ($val) return "<!--".$val."-->\n";
	}
	public function br($val=null){
		return $val."<br />\n";
	}
	public function ahref($target=null,$val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val && $target) return "<a href=\"".$target."\"".$params.">".$val."</a>";
	}
	public function audio($val=null,$type=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "\n<audio".$params.">";
		$result .= "\n<source src=\"".$val."\" type=\"".$type."\">";
		$result .= "\n</audio>";
		if ($val) return $result;
	}
	public function video($val=null,$type=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "\n<video".$params.">";
		$result .= "\n<source src=\"".$val."\" type=\"".$type."\">";
		$result .= "\n</video>";
		if ($val) return $result;
	}
	public function img($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "<img src=\"".$val."\"".$params." />";
	}
	public function get_file_tag($val=null,$type=null,$params=null) {
		if ($params){$params = " ".$params;}
		$data = explode("/",$type);
		if ($data[0] == "audio") {
			return $this->audio($val,$type,"controls=\"controls\"");
		} else if ($data[0] == "video") {
			return $this->video($val,$type,"controls=\"controls\"");
		} else if ($data[0] == "image") {
			return $this->img($val);
		} else {
			return $this->ahref($val,$val);
		}
	}
	public function get_basic_ascii_text($text=null) {
		$text = strip_tags($text);
		$text = trim($text);
		$text = $this->replace_accent($text);
		$text = preg_replace("/[^[:alnum:]\.]/","-",$text);
		$text = preg_replace("/-+/","-",$text);
		return $text;
	}
	public function css($val=null,$external=null){
		$result = "";
		if ($val!=null && $external==null){
			$result = "\n<style type=\"text/css\">\n".$val."\n</style>";
		} elseif($val!=null && $external!=null){
			$result = "\n<link href=\"".$val."\" rel=\"stylesheet\" type=\"text/css\" />";
		}
		if ($val) return $result;
	}
	public function script($val=null,$external=null){
		$result = "";
		if ($val!=null && $external==null){
			$result = "\n<script type=\"text/javascript\">\n".$val."\n</script>";
		} elseif($val!=null && $external!=null && file_exists($val)){
			$result = "\n<script src=\"".$val."\" type=\"text/javascript\"></script>";
		}
		if ($val) return $result;
	}
	public function form($val="",$name=null,$method=null,$action=null,$enctype=null){
		$result = "";
		$result = "\n<form ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		if ($method != null) $result .= "method=\"".$method."\" ";
		if ($action != null) $result .= "action=\"".$action."\" ";
		if ($enctype != null) $result .= "enctype=\"".$enctype."\" ";
		$result .= ">";
		$result .= $val;
		$result .= "\n</form>";
		if ($val) return $result;
	}
	public function textarea($val=null,$name=null,$sizes=array(4,80),$params=null){
		$result = "\n<textarea ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		$result .= "rows=\"".$sizes[0]."\" cols=\"".$sizes[1]."\" ";
		if ($params != null) $result .= $params;
		$result .= ">";
		$result .= $val;
		$result .= "</textarea>";
		return $result;
	}
	public function input($type=null,$name=null,$value=null,$params=null){
		$result = "<input ";
		if ($type != null) $result .= "type=\"".$type."\" ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		if ($value != null) $result .= "value=\"".$value."\" ";
		if ($params != null) $result .= $params." ";
		$result .= "/>";
		if ($type) return $result;
	}
    public function select($options=null,$name=null,$selected=null,$params=null){
		if ($name){$name = " id=\"".$name."\" name=\"".$name."\"";}
		if ($params){$params = " ".$params;}
		return "\n<select".$name.$params.">".$this->options($options,$selected)."\n</select>";
	}
    public function selectOnChangeMenu($options=null,$name=null,$selected=null){
		if ($name){$name = " id=\"".$name."\" name=\"".$name."\"";}
		// return "\n<select".$name." onchange='location.href = \"index.php?\"+document.getElementById(\"v\").value'>".$this->options($options,$selected)."\n</select>";
		return "\n<select".$name." onchange='this.form.submit()'>".$this->options($options,$selected)."\n</select>";
	}
	function options($options=null,$selected=null){
		$optionsList = array();
		foreach($options as $item=>$value){
			if ($value == $selected){
				$optionsList[] =  "<option value=\"".$value."\" selected=\"selected\">".$item."</option>"; 
			} else {
				$optionsList[] =  "<option value=\"".$value."\">".$item."</option>"; 
			}
		}
		return implode("\n",$optionsList);
	}
	public function fieldset($val=null,$params=null){
		return $this->tag("fieldset",$val,$params);
	}
	public function label($val=null,$params=null){
		return $this->tag("label",$val,$params);
	}
	public function crypt($word){
		// $salt = "48@!alsd";
		// $password = "toto";
		// $password_crypt = sha1(sha1($password).$salt);
		if (function_exists('sha1')){ // Only in PHP 4.3.0+
			return sha1($word);
		} elseif (function_exists('mhash')){ // Only if Mhash library is loaded
			return bin2hex(mhash(MHASH_SHA1, $word));
		} else {
			return md5($word);
		}
	}
	public function num($num){
		if (!preg_match("/^[0-9]+$/",trim($num))) exit("number entry incorrect !");
		return $num;
	}
	public function word($word){
		if ($word && !preg_match("/^[A-Za-z0-9_\/\.\:]+$/",trim($word))) exit("word entry incorrect !");
		return $word;
	}
	public function safe($val=null){
		if ( get_magic_quotes_gpc() ) $val = stripslashes($val);
		$dbLink = mysqli_connect(HOSTMYSQL,USERMYSQL,PASSMYSQL,BASEMYSQL) or die("Error " . mysqli_error($link)); 
		$result = mysqli_real_escape_string($dbLink,$val);
		mysqli_close($dbLink);
		return $result;
	}
	public function strWidthLeft($val=null,$size=128){
		$val = strip_tags(html_entity_decode(utf8_decode(trim($val))));
		if (strlen($val) > $size){
			$result = substr($val,0,$size);
			$words = array_filter(explode(" ",$result));
			// delete last word fragment
			if (count($words) > 1) array_pop($words);
			$result = implode($words," ")."...";
		} else {
			$result = $val;
		}
		return utf8_encode($result);
	}
	public function strWidth($val=null,$size=64){
		$val = strip_tags(html_entity_decode(utf8_decode(trim($val))));
		$stringLen = strlen($val);
		if ( $stringLen > $size ){
			$e = floor(($size-2) / 2);
			$result = substr($val,0,$e)."..".substr($val,-$e);
		} else {
			$result = $val;
		}
		if (strlen($result) < $size) $result = $result.str_repeat("&nbsp;",$size-strlen($result));
		return utf8_encode($result);
	}
	public function u_code($val=Null){
		return urlencode($val);
	}
	public function uly_htmlentities($val=Null){
		return htmlentities($val,ENT_QUOTES,"UTF-8");
	}
	public function uly_strip_tags($val=Null){
		return strip_tags(trim($val));
	}
	public function ulyxCredits($firstLine=True,$secondLine=True){
		$t = new Translate();
		$version =  defined('VERSION')?VERSION:"0.0.0";
		$firstLine = ($firstLine)?$this->p($this->ahref("index.php?k=contact&amp;v=0",$t->w("Contact website"))." ".$this->ahref("login.php",$t->w("Login")),"class='credits'"):"";
		$secondLine = ($secondLine)?$this->p($this->ahref("http://ulyxex.logz.org",$t->wr("Made with Ulyxex").$version)."&nbsp;".$this->ahref("http://artlibre.org/licence/lal/en",$t->w("Copyleft Free Art License")),"class='credits'"):"";
		return $this->footer($firstLine.$secondLine);
	}
	public function countQ(){
		return $this->p("queries = ".$_SESSION['countqueries']);
    }
	public function fmt($val){
		return sprintf("%'-4d",$val);
	}
	public function print_rr($arr=array()){
		echo "<pre>",print_r($arr,true),"</pre>";
	}
	public function root_url($val=null){
		$script = isset($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF']:null;
		$script = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME']:null;
		$script = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI']:null;
		if ( preg_match("/\//",$script) ){
			$relativPath = array();
			$relativPath = explode("/",$script);
			array_pop($relativPath);
			$localDir = implode("/",$relativPath);
		} else {
			$localDir = "";
		}
		if (isset($_SERVER['HTTP_HOST'])){
			$result = "http://".$_SERVER['HTTP_HOST'].$localDir."/"; 
		} elseif ( isset($_SERVER['SERVER_NAME']) ){
			$result = "http://".$_SERVER['SERVER_NAME'].$localDir."/";
		} else {
			$result = $localDir."/";
		}
		if (!empty($val)) $result .= $val;
		return $result;
	}
	function replace_accent($val=null) {
		$accents = array(
		"À"=>"A","à"=>"a","Á"=>"A","á"=>"a","Â"=>"A","â"=>"a","Ã"=>"A","ã"=>"a",
		"Ä"=>"A","ä"=>"a","Å"=>"A","å"=>"a","Æ"=>"AE","æ"=>"ae","Ç"=>"C","ç"=>"c",
		"È"=>"E","è"=>"e","É"=>"E","é"=>"e","Ê"=>"E","ê"=>"e","Ë"=>"E","ë"=>"e",
		"Ì"=>"I","ì"=>"i","Í"=>"I","í"=>"i","Î"=>"I","î"=>"i","Ï"=>"I","ï"=>"i",
		"Ð"=>"D","ð"=>"o","Ñ"=>"N","ñ"=>"n","Ò"=>"O","ò"=>"o","Ó"=>"O","ó"=>"o",
		"Ô"=>"O","ô"=>"o","Õ"=>"O","õ"=>"o","Ö"=>"O","ö"=>"o","×"=>"x","÷"=>"div",
		"Ø"=>"O","ø"=>"o","Ù"=>"U","ù"=>"u","Ú"=>"U","ú"=>"u","Û"=>"U","û"=>"u",
		"Ü"=>"U","ü"=>"u","Ý"=>"Y","ý"=>"y","Þ"=>"e","þ"=>"E","ß"=>"B","ÿ"=>"y"
		);
		$result = "";
		$end = strlen($val);
		for ($i = 0; $i < $end; $i++) {
			if ( array_key_exists($val[$i],$accents) ) $result .= $accents[$val[$i]]; else $result .= $val[$i];
		}
		return $result;
	}
	public function get_ext($fileName=null){
		$data = explode(".",$fileName);
		$ext = array_pop($data);
		$ext = strtolower($ext);
		return $ext;
	}
}
?>
