<?php
/* Ulyxex version 1.4.0 *****************/
require_once("config.php");
require_once("pages/core/ulyxex.php");
if (!defined('FILES')) define("FILES",$prefixTableMySql."files");
require_once("pages/core/html.php");

$h = new Html();
$uly = new Ulyxex();
$css = $h->css("css/view_style.css","external");
$meta = $h->meta("Content-Type","text/html; charset=UTF-8");
$title = $h->title("Update ulyxex");
$head = $h->head($meta.$css.$title);

$topPage = $h->p("web site ".$h->ahref($h->root_url(),$h->root_url()));
$page = $h->h2("Update process");

if ($update = @file("version.txt")){
	foreach($update as $line){
		if ( preg_match("/version/i",$line) ){
			$tmp = explode("=",$line);
			$version = trim($tmp[1]);
		} 
		if ( preg_match("/update/i",$line) ){
			$tmp = explode("=",$line);
			$version = trim($tmp[1]);
		} 
		if ( preg_match("/date/",$line) ){
			$tmp = explode("=",$line);
			$oldUpdateDate = trim($tmp[1]);
		}
	}
	$page .= $h->p("version.txt file exist VERSION ".$version." date ".$oldUpdateDate);
} else {
	$page .= $h->p("version.txt file don't exist then VERSION 0.0.0");
	$version = "0.0.0";
}

if ($update = @file("update.txt")){
	foreach($update as $line){
		if ( preg_match("/version/i",$line) ){
			$tmp = explode("=",$line);
			$version = trim($tmp[1]);
		}
		if ( preg_match("/update/i",$line) ){
			$tmp = explode("=",$line);
			$version = trim($tmp[1]);
		} 
		if ( preg_match("/date/",$line) ){
			$tmp = explode("=",$line);
			$oldUpdateDate = trim($tmp[1]);
		}
	}
	$page .= $h->p("update.txt file exist VERSION ".$version." date ".$oldUpdateDate);
}

$newVersion = $version;

if ($version < "0.1.1"){
	$newVersion = "0.1.1";
	$up = "";
	$query = "ALTER TABLE ".PAGES." ADD `SORTSTYLE` tinyint NOT NULL";
	$up .=  $h->p($uly->qTest($query));
	$page .=  $h->p("Update to ".$newVersion.$up);
}
if ($version < "0.1.2"){
	$newVersion = "0.1.2";
	$up = "";
	$up .=  $h->p("add DATE to table ".PAGES);
	$query = "ALTER TABLE ".PAGES." ADD `DATE` datetime NOT NULL";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("add DATE to table ".USERS);
	$query = "ALTER TABLE ".USERS." ADD `DATE` datetime NOT NULL";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("add DATE to table ".LINKS);
	$query = "ALTER TABLE ".LINKS." ADD `DATE` datetime NOT NULL";
	$up .= 	$h->p($uly->qTest($query));
	$page .= $h->p("Update to ".$newVersion.$up);
}
if ($version < "0.1.3"){
	$newVersion = "0.1.3";
	$up = "";
	$up .=  $h->p("add PAGEHEAD to table ".PAGES);
	$query = "ALTER TABLE ".PAGES." ADD `PAGEHEAD` mediumtext NOT NULL";
	$up .=  $h->p($uly->qTest($query));
	$page .=  $h->p("Update to ".$newVersion.$up);
}
if ($version < "1.1.1"){
	$newVersion = "1.1.1";
	$up = "";
	$up .=  $h->p("add TYPE to table ".PARAMS);
	$query = "ALTER TABLE ".PARAMS." ADD `TYPE` VARCHAR(32) NOT NULL DEFAULT 'page';";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("add TYPE to table ".PAGES);
	$query = "ALTER TABLE ".PAGES." ADD `TYPE` VARCHAR(32) NOT NULL DEFAULT 'page' AFTER `PAGEHEAD`";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("add LINK to table ".PAGES);
	$query = "ALTER TABLE ".PAGES." ADD `LINK` TINYTEXT NOT NULL AFTER `TYPE`;";
	$up .=  $h->p($uly->qTest($query));
	$page .=  $h->p("Update to ".$newVersion.$up);
}
if ($version < "1.1.2"){
	$newVersion = "1.1.2";
	$up = "";
	$up .=  $h->p("change TYPE to TYPEPAGE in table ".PARAMS);
	$query = "ALTER TABLE ".PARAMS." CHANGE `TYPE` `TYPEPAGE` VARCHAR(32) NOT NULL DEFAULT 'page';";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("change TYPE to TYPEPAGE in table ".PAGES);
	$query = "ALTER TABLE ".PAGES." CHANGE `TYPE` `TYPEPAGE` VARCHAR(32) NOT NULL DEFAULT 'page';";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("change DATE to DATEPAGE in table ".ARTICLES);
	$query = "ALTER TABLE ".ARTICLES." CHANGE `DATE` `DATEPAGE` DATETIME NOT NULL;";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("change DATE to DATEPAGE in table ".PAGES);
	$query = "ALTER TABLE ".PAGES." CHANGE `DATE` `DATEPAGE` DATETIME NOT NULL;";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("change DATE to DATEPAGE in table ".USERS);
	$query = "ALTER TABLE ".USERS." CHANGE `DATE` `DATEPAGE` DATETIME NOT NULL;";
	$up .=  $h->p($uly->qTest($query));
	$page .=  $h->p("Update to ".$newVersion.$up);
}
if ($version < "1.1.3"){
	$newVersion = "1.1.3";
	$up = "";
	$up .=  $h->p("add NAVTYPE to table ".PARAMS);
	$query = "ALTER TABLE ".PARAMS." ADD `NAVTYPE` VARCHAR(32) NOT NULL DEFAULT 'tree';";
	$up .=  $h->p($uly->qTest($query));
	$page .=  $h->p("Update to ".$newVersion.$up);
}
if ($version < "1.3.6"){
	$newVersion = "1.3.6";
	$up = "";
	$up .=  $h->p("add LANG to table ".PAGES);
	$query = "ALTER TABLE ".PAGES." ADD `LANG` VARCHAR(2) NOT NULL DEFAULT 'en';";
	$up .=  $h->p($uly->qTest($query));
	$up .=  $h->p("add LANG to table ".ARTICLES);
	$query = "ALTER TABLE ".ARTICLES." ADD `LANG` VARCHAR(2) NOT NULL DEFAULT 'en';";
	$up .=  $h->p($uly->qTest($query));
	$page .=  $h->p("Update to ".$newVersion.$up);
}
if ($version < "1.4.0"){
	$newVersion = "1.4.0";
	$up = "";
	$query = "CREATE TABLE ".FILES." (
	ID mediumint(6) NOT NULL AUTO_INCREMENT,
	USERID mediumint(6) NOT NULL,
	FILENAME mediumtext NOT NULL,
	DATEFILE datetime NOT NULL,
	PRIMARY KEY (ID)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";
	$up .=  $h->p($uly->qTest($query));
	$page .=  $h->p("Update to ".$newVersion.$up);
}
/* write infos 						*/
$date = date("Y-m-d H:i:s",time());
$updateFile = <<<END
update=$newVersion
date=$date
END;

if ($newVersion >= $version) {
	if ($f = fopen("update.txt","w")){
		$page .=  $h->p("write update.txt");
		$page .=  $h->p("update version ".$version." -to-> ".$newVersion);
		fwrite($f,$updateFile);
		fclose($f);
	} else {
		$page .= $h->p("can't write update.txt");
	}
} else {
	$page .= $h->p("not a new version!");
}

$page .= $h->p("Update process done");
$page .= $h->p($h->b("VERSION : ".$newVersion." ... DATE : ".$date,"style='color:blue;'"));
$body = $h->body($topPage.$page);
$page = $h->html($head.$body);

echo $page;
?>




