<?php
/* Ulyxex version 1.3.5 *****************/
/****************************************/
/* clean all sessions 					*/
/* session always before header			*/
session_start();
/* erase all sessions					*/
$_SESSION = array();
/* delete cookies						*/
if (isset($_COOKIE[session_name()])){
	setcookie(session_name(), '', time()-42000, '/');
}
/* destroy sessions						*/
session_destroy();
/****************************************/
/* required								*/
require_once("config.php");
require_once("pages/core/html.php");
require_once("pages/core/translate.php");
/****************************************/
/* page elements						*/
$h = new Html();
$t = new Translate();
$css = $h->css("css/view_style.css","external");
$meta = $h->meta("Content-Type","text/html; charset=UTF-8");
$title = $h->title("login");
$head = $h->head($meta.$css.$title);

$topPage = $h->p($h->root_url());

$bottomPage = $h->ulyxCredits();
/****************************************/
/* page data							*/	
$inputs = $h->p($t->wr("login").$h->input("text","login","login ?","class='login'"));
$inputs .= $h->p( $t->wr("password").$h->input("password","password",null,"class='login'")." ".$h->input("submit",null,"GO") );
$data = $h->form($inputs,"admin","post","admin.php");
/****************************************/
/* show									*/
$body = $h->body($topPage.$data.$bottomPage);
$page = $h->html($head.$body);

echo $page;
?>