<?php
/* Ulyxex version 1.3.3 *****************/
class ViewFiles extends Admin {
	function __construct($dir=null){
		$this->dir = $dir;
		$this->h = New Html();
		$this->t = New Translate();
	}
	public function getFilesUrl() {
		$handle = opendir($this->dir);
		$liste = array();
		while ($file = readdir($handle)){
			if( // don't show this files
				preg_match("/^\./",$file) || // don't show .htaccess etc.
				$file == "index.php" // this script
				){
				continue;
			} else {
				$liste[] = $this->h->root_url($this->dir.$file);
			}// end if
		} // end while
		closedir($handle);
		if (isset($liste[0])) {
			natcasesort($liste);
		}
		return $liste;
	}
	public function directory(){
		$h = $this->h;
		$t = $this->t;
		$result = "";
		$size = 0;
		$date = "";
		$totalSize = 0;
		$dirs = 0; 
		$fics = 0;
		$handle = opendir($this->dir);
		while ($file = readdir($handle)){
			if( // don't show this files
				preg_match("/^\./",$file) || // don't show .htaccess etc.
				$file == "index.php" // this script
				){
				continue;
			} else {
				if ( is_dir($this->dir.$file) ) $dirs++;
				if ( is_file($this->dir.$file) ){
					$fics++;
					$size = sprintf("%d",(filesize($this->dir.$file)/1000));
					$totalSize += $size;
					if ($size > 0) $size .= " ko";
					$params = stat($this->dir.$file);
					$date = date("d/m/Y",$params[9]);	
				}
				$tmp = "";
				if (!empty($size)) $tmp .= $h->b(" ".$size);
				if (!empty($date)) $tmp .= $h->b(" ( ").$date.$h->b(" )");
				$tmp = $h->p($h->b("{ ").$h->ahref($this->dir.$file,$file).$h->b(" }").$tmp);
				$liste[] = $tmp;
				$size = 0;
				$date = "";
			}// end if
		} // end while
		closedir($handle);
		
		if (isset($liste[0])){
			natcasesort($liste);
			$result .= $h->p($h->b($t->w("list files")));
			foreach($liste as $item) $result .= $item;
		}
		
		$result .= $h->p(
			$h->b($h->br("stats:")).
			$h->br($fics.$t->wl("files")).
			$h->br($dirs.$t->wl("directories")).
			$h->br("total  ".sprintf("%d",$totalSize)." ko")
		);
		return $result;
	}
}
?>