<?php
/* Ulyxex version 1.1.5 *****************/
/****************************************/
/* session always before header			*/
session_start();
$_SESSION['countqueries'] = 0;
/****************************************/
/* required								*/
require_once("config.php");
require_once("pages/core/translate.php");
require_once("pages/core/html.php");
require_once("pages/core/ulyxex.php");
require_once("pages/core/tree.php");
require_once("pages/core/admin.php");
/****************************************/
/* classes 								*/
$h = new Html();
$t = new Translate();
$o_admin = new Admin();
/****************************************/
/* login						 		*/
if (isset($_POST['login'])){
	$_SESSION['login'] = $h->word($_POST['login']);
	$_SESSION['password'] = $h->crypt($_POST['password']);
	list($_SESSION['userid'],$_SESSION['level']) = $o_admin->login($_SESSION['login'],$_SESSION['password']);
	$admin = 1;
} elseif (isset($_SESSION['login']) && $_SESSION['login'] != Null){
	// you are logged in back end
	$admin = 1;
} else {
	exit("not allowed !");
}
/****************************************/
/* catch action							*/
$action =(isset($_GET['action']))?$h->word($_GET['action']):null;

/* add more admin actions and menu items
element 0 = title of action, use *....* to avoid translation
element 1 = link of file
element 2 = "action" action in menu or "link" simple link in menu
element 3 = level of user
*/
$adminController["pages"]			= array("pages","pages/admin_pages.php","action",2);
$adminController["add_page"] 		= array("add page","pages/admin_page_add.php",null,2);
$adminController["modify_page"] 		= array("modify page","pages/admin_page_modify.php",null,2);	

$adminController["articles"] 		= array("articles","pages/admin_articles.php","action",4);
$adminController["add_article"] 		= array("add article","pages/admin_article_add.php",null,4);
$adminController["modify_article"] 	= array("modify article","pages/admin_article_modify.php",null,4);
	
$adminController["multiples_uploads"]= array("uploads","pages/admin_files_uploads.php","action",3);
$adminController["files"]			= array("files","files/index.php",null,3);

$adminController["users"] 			= array("users","pages/admin_users.php","action",1);
$adminController["add_user"] 		= array("admin home","pages/admin_user_add.php","",1);
$adminController["modify_user"] 		= array("admin home","pages/admin_user_modify.php",null,1);
$adminController["my_user_profile"] 	= array("my user profile","admin.php?action=modify_user&amp;user=".$_SESSION['userid'],"link",4);

$adminController["admin_home"] 		= array("admin home","pages/admin_home.php","action",1);

$adminController["login"]			= array("login","login.php","link",4);
$adminController["logout"]			= array("logout","logout.php","link",4);
$adminController["help"]				= array("help","http://ulyxex.logz.org/index.php?k=page&amp;v=3","link",4);
/****************************************/
/* create menu (actions links)	 		*/
$adminNavigation = new AdminNavigation($adminController);

/****************************************/
/* process								*/
if ( $action && array_key_exists($action , $adminController) ){
	require_once($adminController[$action][1]);
} else {
	/* default action */
	if ($_SESSION['level'] > 0 && $_SESSION['level'] <= 2){
		require_once("pages/admin_pages.php");
	} elseif ($_SESSION['level'] > 0 && $_SESSION['level'] <= 4) {
		require_once("pages/admin_articles.php");
	} else {
		exit("error level !");
	}
}
/****************************************/
/* class for admin menu					*/
class AdminNavigation {
	function __construct($index=array()){
		$h = New Html();
		$t = New Translate();
		foreach ($index as $action => $vals) {
			$name = $vals[0];
			$link = $vals[1];
			$menu = $vals[2];
			$level = $vals[3];
			if ($menu == "action") { // menu actions
				if ($level >= 1) {
					$level1[] = $h->ahref("admin.php?action=".$action,$t->w($name),"class='action'");
				}
				if ($level >= 2) {
					$level2[] = $h->ahref("admin.php?action=".$action,$t->w($name),"class='action'");
				}
				if ($level >= 3) {
					$level3[] = $h->ahref("admin.php?action=".$action,$t->w($name),"class='action'");
				}
				if ($level >= 4) {
					$level4[] = $h->ahref("admin.php?action=".$action,$t->w($name),"class='action'");
				}
			}
			if ($menu == "link") { // menu direct links
				if ($level >= 1) {
					$level1[] = $h->ahref($link,$t->w($name),"class='action'");
				}
				if ($level >= 2) {
					$level2[] = $h->ahref($link,$t->w($name),"class='action'");
				}
				if ($level >= 3) {
					$level3[] = $h->ahref($link,$t->w($name),"class='action'");
				}
				if ($level >= 4) {
					$level4[] = $h->ahref($link,$t->w($name),"class='action'");
				}
			}
		}
		$_ = array("",implode(" ",$level1),implode(" ",$level2),implode(" ",$level3),implode(" ",$level4));
		$this->links = $_[$_SESSION['level']];
	}
}
?>
