<?php
/* Ulyxex version 1.1.4 *****************/
class Tree extends Ulyxex {
	function __construct(){
		$this->h = New Html();
		$this->t = New Translate();
		$this->parentOf = array();
		$this->name = array();
	}
	public function paths($hide=Null){
		$paths = array();
		if ($hide){
			$query = "SELECT ID,NAME,TYPEPAGE,PARENTID FROM ".PAGES." WHERE HIDE != 1";
		} else {
			$query = "SELECT ID,NAME,TYPEPAGE,PARENTID FROM ".PAGES;
		}
		
		$query = $this->q($query);
		
		while ( $line = $this->fetch($query) ){
			$this->parentOf[$line['ID']] = $line['PARENTID'];
			$this->name[$line['ID']] = $line['NAME'];
			$this->type[$line['ID']] = $line['TYPEPAGE'];
		}

		foreach($this->parentOf as $child => $parent){
			$ancestorId = 0;
			$ancestorsNames = array();
			if ($parent == 0){
				// if parent is home
				$lineage = "/".$this->name[$child]."/";
				$paths[$lineage] = array($this->type[$child],$child); 
			} else {
				// if parent other than home exist
				// add parent
				if (isset($this->name[$parent])){
					// check if error in lineage
					if ( in_array($this->name[$parent],$ancestorsNames) ){print " error tree !";break;}
					$ancestorsNames[] = $this->name[$parent];
				}
				// if a gran parent exist
				if (array_key_exists($parent, $this->parentOf)){ 
					$ancestorId = $this->parentOf[$parent];
					// if others gran gran... parent exist
					while ($ancestorId != 0){
						if (isset($this->name[$ancestorId])){
							// check if error in lineage
							if ( in_array($this->name[$ancestorId],$ancestorsNames) ){print " error tree !";break;}
							$ancestorsNames[] = $this->name[$ancestorId];
						}
						
						if (isset($this->parentOf[$ancestorId]) && $this->parentOf[$ancestorId] != 0){ 
							$ancestorId = $this->parentOf[$ancestorId];
						} else {
							$ancestorId = 0;
						}
					}
					$ancestorsNames = array_reverse($ancestorsNames);
					$lineage = "/".implode("/",$ancestorsNames)."/".$this->name[$child]."/";
					$paths[$lineage] = array($this->type[$child],$child); 
				}
				
			}
		}
		// $_ = array();
		// foreach($paths as $k=>$v){
			// $_[$this->h->strWidth($k,50)] = $v;
		// }
		// $paths = $_;
		return $paths;
	}
	public function pathsSelect($selected=Null,$root=1,$type=Null){
		$paths = $this->paths();
		ksort($paths);
		$options = array();
		if ($root) $options["ROOT/"] = 0;
		foreach($paths as $path => $idVal){
			$pathLevels = explode("/",$path);
			$path = "ROOT-";
			$path .= str_repeat("-",count($pathLevels)-3); // 3 for first "/", last "/" and array position
			array_pop($pathLevels);
			$path .= ">".array_pop($pathLevels);
			if ($type) {
				if ($idVal[0] == $type) $options[$path.$this->h->comments($idVal[1])] = $idVal[1];
			} else {
				$options[$path.$this->h->comments($idVal[1])] = $idVal[1];
			}
			
		}
		return $this->h->select($options,"parent",$selected);
	}
	public function pathTest($page=0,$parent=0){
		$paths = $this->paths();
		$lineage = explode("/",array_search($parent,$paths));
		return (in_array($this->name[$page],$lineage))?0:1;
	}
	public function pathPage($parent=0){
		$paths = $this->paths();
		return array_search($parent,$paths);
	}
	function getMenuChilds($page=0,$pageType="",$menuParams=""){
		$h = $this->h; $t = $this->t;
		$menu = array();
		// get child pages
		$query = "SELECT ID,NAME,TYPEPAGE,PARENTID FROM ".PAGES." WHERE PARENTID = ".$page." AND HIDE != 1";
		$query = $this->q($query);
		while ( $line = $this->fetch($query) ){
			array_push($menu,$h->ahref("index.php?k=".$line['TYPEPAGE']."&v=".$line['ID'].$menuParams,$line['NAME'],"class='menu'"));
		}
		sort($menu);
		if (count($menu) > 0) { // if child add sign
			array_unshift($menu,"->");
		}
		
		// get current page
		$query = "SELECT ID,NAME,TYPEPAGE,PARENTID FROM ".PAGES." WHERE ID = ".$page." AND HIDE != 1";
		$query = $this->q($query);
		$line = $this->fetch($query);
		array_unshift($menu,$h->ahref("index.php?k=".$line['TYPEPAGE']."&v=".$line['ID'].$menuParams,$line['NAME'],"class='menu'"));
		
		// get root childs
		if ($line['PARENTID'] != 0) {
			$query = "SELECT ID,NAME,TYPEPAGE FROM ".PAGES." WHERE ID = ".$line['PARENTID']." AND HIDE != 1";
			$query = $this->q($query);
			$line = $this->fetch($query);
			array_unshift($menu,$h->ahref("index.php?k=".$line['TYPEPAGE']."&v=".$line['ID'].$menuParams,$line['NAME'],"class='menu'")." <-");
		}
		return $h->h2(implode(" ",$menu));
	}
	function getMenuForm($page=0,$pageType="",$menuParams=""){
		$h = $this->h;$t = $this->t;
		$paths = $this->paths($hide=1); // prevent showing hide links
		ksort($paths);
		$pages_paths = array();
		$selectedPath = "k=".$pageType."&amp;v=".$page;
		$navigationTitle = "--".$t->w("Pages").str_repeat("-",20-strlen($t->w("Pages")));
		// pages
		$pages_paths[$navigationTitle] = "limit";
		foreach($paths as $path => $idVal){
			$pathLevels = explode("/",$path);
			$path = str_repeat("-",count($pathLevels)-3); // 3 for first "/", last "/" and array position
			if (count($pathLevels)-3 > 0) $path .= "> ";
			array_pop($pathLevels);
			$path .= array_pop($pathLevels);
			$pages_paths[$path.$h->comments($idVal[1])] = "k=".$idVal[0]."&amp;v=".(string)$idVal[1].$menuParams;
		}
		$options = $pages_paths;
		$menu = $h->p($h->selectOnChange($options,"v",$selectedPath));
		return $h->form($menu,"navform","post","");
	}
	function getMenuLine($page=0,$pageType="",$menuParams=""){
		$h = $this->h;$t = $this->t;
		$menu = array();
		$query = "SELECT ID,NAME,TYPEPAGE FROM ".PAGES." WHERE HIDE != 1";
		$query = $this->q($query);
		while ( $line = $this->fetch($query) ){
			$menu[] = $h->ahref("index.php?k=".$line['TYPEPAGE']."&v=".$line['ID'].$menuParams,$line['NAME'],"class='menu'");
		}
		sort($menu);
		return $h->h2(implode(" ",$menu));
	}	
	public function pagesNavigation($page=0,$pageType="page",$menuStyle=null,$menuParams=""){
		if (!$menuStyle and defined('MENUSTYLE')) {
			$menuStyle = MENUSTYLE;
		}
		
		if ($menuStyle == "line") {
			return $this->getMenuLine($page=$page,$pageType=$pageType,$menuParams="");
		} elseif($menuStyle == "child") {
			return $this->getMenuChilds($page=$page,$pageType=$pageType,$menuParams="");
		} else {
			$menuStyle = "tree";
			return $this->getMenuForm($page=$page,$pageType=$pageType,$menuParams="");
		}
	}
}  
?>