<?php
/* Ulyxex version 1.1.0 *****************/
class Tree extends Ulyxex {
	function __construct(){
		$this->h = New Html();
		$this->t = New Translate();
		$this->parentOf = array();
		$this->name = array();
	}
	public function paths($hide=Null){
		$paths = array();
		if ($hide){
			$query = "SELECT ID,NAME,PARENTID FROM ".PAGES." WHERE HIDE != 1";
		} else {
			$query = "SELECT ID,NAME,PARENTID FROM ".PAGES;
		}
		
		$query = $this->q($query);
		
		while ( $line = $this->fetch($query) ){
			$this->parentOf[$line['ID']] = $line['PARENTID'];
			$this->name[$line['ID']] = $line['NAME'];
		}

		foreach($this->parentOf as $child => $parent){
			$ancestorId = 0;
			$ancestorsNames = array();
			if ($parent == 0){
				// if parent is home
				$lineage = "/".$this->name[$child]."/";
				$paths[$lineage] = $child; 
			} else {
				// if parent other than home exist
				// add parent
				if (isset($this->name[$parent])){
					// check if error in lineage
					if ( in_array($this->name[$parent],$ancestorsNames) ){print " error tree !";break;}
					$ancestorsNames[] = $this->name[$parent];
				}
				// if a gran parent exist
				if (array_key_exists($parent, $this->parentOf)){ 
					$ancestorId = $this->parentOf[$parent];
					// if others gran gran... parent exist
					while ($ancestorId != 0){
						if (isset($this->name[$ancestorId])){
							// check if error in lineage
							if ( in_array($this->name[$ancestorId],$ancestorsNames) ){print " error tree !";break;}
							$ancestorsNames[] = $this->name[$ancestorId];
						}
						
						if (isset($this->parentOf[$ancestorId]) && $this->parentOf[$ancestorId] != 0){ 
							$ancestorId = $this->parentOf[$ancestorId];
						} else {
							$ancestorId = 0;
						}
					}
					$ancestorsNames = array_reverse($ancestorsNames);
					$lineage = "/".implode("/",$ancestorsNames)."/".$this->name[$child]."/";
					$paths[$lineage] = $child; 
				}
				
			}
		}
		// $_ = array();
		// foreach($paths as $k=>$v){
			// $_[$this->h->strWidth($k,50)] = $v;
		// }
		// $paths = $_;
		return $paths;
	}
	public function pathsSelect($selected=Null,$root=1){
		$paths = $this->paths();
		ksort($paths);
		$options = array();
		if ($root) $options["ROOT/"] = 0;
		foreach($paths as $path => $idVal){
			$pathLevels = explode("/",$path);
			$path = "ROOT-";
			$path .= str_repeat("-",count($pathLevels)-3); // 3 for first "/", last "/" and array position
			array_pop($pathLevels);
			$path .= ">".array_pop($pathLevels);
			$options[$path.$this->h->comments($idVal)] = $idVal;
		}
		return $this->h->select($options,"parent",$selected);
	}
	public function pathTest($page=0,$parent=0){
		$paths = $this->paths();
		$lineage = explode("/",array_search($parent,$paths));
		return (in_array($this->name[$page],$lineage))?0:1;
	}
	public function pathPage($parent=0){
		$paths = $this->paths();
		return array_search($parent,$paths);
	}
	function getMenuChilds($page=0){
		$h = $this->h; $t = $this->t;
		$menu = array();
		// get child pages
		$query = "SELECT ID,NAME,PARENTID FROM ".PAGES." WHERE PARENTID = ".$page." AND HIDE != 1";
		$query = $this->q($query);
		while ( $line = $this->fetch($query) ){
			array_push($menu,$h->ahref("index.php?k=page&v=".$line['ID'],$line['NAME'],"class='menu'"));
		}
		sort($menu);
		if (count($menu) > 0) { // if child add sign
			array_unshift($menu,"->");
		}
		
		// get links
		$query = "SELECT "."ID,NAME FROM ".LINKS." WHERE HIDE != 1 ORDER BY NAME";
		$query = $this->q($query);
		while ( $line = $this->fetch($query) ){
			$menu[] = $h->ahref("index.php?k=page&v="."link".$line['ID'],$line['NAME'],"class='menu'");
		}
		
		// get page
		$query = "SELECT ID,NAME,PARENTID FROM ".PAGES." WHERE ID = ".$page." AND HIDE != 1";
		$query = $this->q($query);
		$line = $this->fetch($query);
		array_unshift($menu,$h->ahref("index.php?k=page&v=".$line['ID'],$line['NAME'],"class='menu'"));
		
		// get parent
		if ($line['PARENTID'] != 0) {
			$query = "SELECT ID,NAME FROM ".PAGES." WHERE ID = ".$line['PARENTID']." AND HIDE != 1";
			$query = $this->q($query);
			$line = $this->fetch($query);
			array_unshift($menu,$h->ahref("index.php?k=page&v=".$line['ID'],$line['NAME'],"class='menu'")." <-");
		}
		return $h->h2(implode(" ",$menu));
	}
	function getMenuForm($page=0){
		$h = $this->h;$t = $this->t;
		$paths = $this->paths($hide=1); // prevent showing hide links
		ksort($paths);
		$pages_paths = array();
		$selectedPath = $page;
		$navigationTitle = "--".$t->w("Pages").str_repeat("-",20-strlen($t->w("Pages")));
		$linksTitle = "--".$t->w("Links").str_repeat("-",20-strlen($t->w("Links")));
		// pages
		$pages_paths[$navigationTitle] = "limit";
		foreach($paths as $path => $idVal){
			$pathLevels = explode("/",$path);
			$path = str_repeat("-",count($pathLevels)-3); // 3 for first "/", last "/" and array position
			if (count($pathLevels)-3 > 0) $path .= "> ";
			array_pop($pathLevels);
			$path .= array_pop($pathLevels);
			$pages_paths[$path.$h->comments($idVal)] = $idVal;
		}
		
		// links
		$query = "SELECT "."ID,NAME FROM ".LINKS." WHERE HIDE != 1 ORDER BY NAME";
		$query = $this->q($query);
		$link_paths = array();
		$separation = 1;
		while ( $line = $this->fetch($query) ){
				if ($separation){
					$link_paths[$linksTitle] = "limit";
				$separation = 0;
			}
			$link_paths["- ".$line['NAME']] = "link".$line['ID'];
		}
		$options = array_merge($pages_paths,$link_paths);
		$menu = $h->p($h->selectOnChange($options,"v",$selectedPath).$h->input("hidden","k","page")." ".$h->input("submit",null,"GO"));
		return $h->form($menu,"navform","post","index.php");
	}
	function getMenuLine($page=0){
		$h = $this->h;$t = $this->t;
		$menu = array();
		$query = "SELECT ID,NAME FROM ".PAGES." WHERE HIDE != 1";
		$query = $this->q($query);
		while ( $line = $this->fetch($query) ){
			$menu[] = $h->ahref("index.php?k=page&v=".$line['ID'],$line['NAME'],"class='menu'");
		}
		sort($menu);
		$query = "SELECT "."ID,NAME FROM ".LINKS." WHERE HIDE != 1 ORDER BY NAME";
		$query = $this->q($query);
		while ( $line = $this->fetch($query) ){
			$menu[] = $h->ahref("index.php?k=page&v="."link".$line['ID'],$line['NAME'],"class='menu'");
		}
		sort($menu);
		return $h->h2(implode(" ",$menu));
	}	
	public function pagesNavigation($page=0){
		$h = $this->h;$t = $this->t;
		if (defined('MENUSTYLE')) {
			$menuStyle = MENUSTYLE;
		} else {
			$menuStyle = "tree";
		}
		
		if ($menuStyle == "tree") {
			return $this->getMenuForm($page=$page);
		} elseif ($menuStyle == "line") {
			return $this->getMenuLine($page=$page);
		} elseif($menuStyle == "child") {
			return $this->getMenuChilds($page=$page);
		}
	}
}  
?>