<?php
/* Ulyxex version 1.1.0 *****************/
class Html {
	public function html($val=null,$params=null){
		return $this->html5($val,$params);
	}
	public function html5($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "<!DOCTYPE HTML>\n";
		$result .= "<html".$params.">";
		$result .= $val."\n</html>";
		return $result;
	}
	public function html4($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
		$result .= "<html".$params.">";
		$result .= $val."\n</html>";
		return $result;
	}
	public function xhtml1($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?".">\n";
		$result .= "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/html51/DTD/html51-transitional.dtd\">\n";
		$result .= "<html xmlns=\"http://www.w3.org/1999/xhtml\"".$params.">";
		$result .= $val."\n</html>\n";
		return $result;
	}
	public function error404(){
		$head = $this->title("404 Not Found");
		$body = $this->h1("Not Found").$this->p("The requested URL ".$_SERVER['PHP_SELF']." was not found on this server.");
		return $this->html5($this->head($head).$this->body($body));
	}
	public function body($val=null,$params=null){
		if ($params){$params = " ".$params;}
		return "\n<body".$params.">".$val."\n</body>";
	}
	public function head($val=null){
		return "\n<head>".$val."\n</head>";
	}
	public function meta($http=null,$content=null){
		if ($http) return "\n<meta http-equiv=\"".$http."\" content=\"".$content."\" />";
	}
	public function title($val=null){
		if ($val) return "\n<title>".$val."</title>";;
	}
	public function ico($val=null){
		if ($val && file_exists($val)) return "<link rel=\"icon\" type=\"image/png\" href=\"".$val."\" />";
	}
	public function h1($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<h1".$params.">".$val."\n</h1>";
	}
	public function h2($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<h2".$params.">".$val."\n</h2>";
	}
	public function h3($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "\n<h3".$params.">".$val."\n</h3>";
		if ($val) return $result;
	}
	public function p($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<p".$params.">".$val."\n</p>";
	}
	function b($val=null){
		if ($val) return "<strong>".$val."</strong>";
	}
	public function pre($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<pre".$params.">".$val."\n</pre>";
	}
	public function div($val=null,$params=null){
		if ($params){$params = " ".$params;}
		$result = "\n<div".$params.">".$val."\n</div>";
		if ($val) return $result;
	}
	public function span($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "<span".$params.">".$val."</span>";
	}
	public function ol($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<ol".$params.">".$val."\n</ol>";
	}
	public function ul($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<ul".$params.">".$val."\n</ul>";
	}
	public function li($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<li".$params.">".$val."</li>";
	}
	public function comments($val=null){
		if ($val) return "<!--".$val."-->\n";
	}
	public function br($val=null){
		return $val."<br />\n";
	}
	public function ahref($target=null,$val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val && $target) return "<a href=\"".$target."\"".$params.">".$val."</a>";
	}
	public function img($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "<img src=\"".$val."\"".$params." />";
	}
	public function css($val=null,$external=null){
		$result = "";
		if ($val!=null && $external==null){
			$result = "\n<style type=\"text/css\">\n".$val."\n</style>";
		} elseif($val!=null && $external!=null){
			$result = "\n<link href=\"".$val."\" rel=\"stylesheet\" type=\"text/css\" />";
		}
		if ($val) return $result;
	}
	public function script($val=null,$external=null){
		$result = "";
		if ($val!=null && $external==null){
			$result = "\n<script type=\"text/javascript\">\n".$val."\n</script>";
		} elseif($val!=null && $external!=null && file_exists($val)){
			$result = "\n<script src=\"".$val."\" type=\"text/javascript\"></script>";
		}
		if ($val) return $result;
	}
	public function form($val="",$name=null,$method=null,$action=null,$enctype=null){
		$result = "";
		$result = "\n<form ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		if ($method != null) $result .= "method=\"".$method."\" ";
		if ($action != null) $result .= "action=\"".$action."\" ";
		if ($enctype != null) $result .= "enctype=\"".$enctype."\" ";
		$result .= ">";
		$result .= $val;
		$result .= "\n</form>";
		if ($val) return $result;
	}
	public function textarea($val=null,$name=null,$sizes=array(4,80),$params=null){
		$result = "\n<textarea ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		$result .= "rows=\"".$sizes[0]."\" cols=\"".$sizes[1]."\" ";
		if ($params != null) $result .= $params;
		$result .= ">";
		$result .= $val;
		$result .= "</textarea>";
		return $result;
	}
	public function input($type=null,$name=null,$value=null,$params=null){
		$result = "<input ";
		if ($type != null) $result .= "type=\"".$type."\" ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		if ($value != null) $result .= "value=\"".$value."\" ";
		if ($params != null) $result .= $params." ";
		$result .= "/>";
		if ($type) return $result;
	}
    public function select($options=null,$name=null,$selected=null){
		if ($name){$name = " id=\"".$name."\" name=\"".$name."\"";}
		return "\n<select".$name.">".$this->options($options,$selected)."\n</select>";
	}
    public function selectOnChange($options=null,$name=null,$selected=null){
		if ($name){$name = " id=\"".$name."\" name=\"".$name."\"";}
		// return "\n<select".$name." onchange='this.form.submit()'>".$this->options($options,$selected)."\n</select>";
		return "\n<select".$name." onchange='location.href = \"index.php?k=page&amp;v=\"+document.getElementById(\"v\").value'>".$this->options($options,$selected)."\n</select>";
	}
	function options($options=null,$selected=null){
		$optionsList = array();
		foreach($options as $item=>$value){
			if ($value == $selected){
				$optionsList[] =  "<option value=\"".$value."\" selected=\"selected\">".$item."</option>"; 
			} else {
				$optionsList[] =  "<option value=\"".$value."\">".$item."</option>"; 
			}
		}
		return implode("\n",$optionsList);
	}
	public function fieldset($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<fieldset".$params.">\n".$val."\n</fieldset>";
	}
	public function label($val=null,$params=null){
		if ($params){$params = " ".$params;}
		if ($val) return "\n<label".$params.">".$val."</label>\n";
	}
	public function crypt($word){
		// $salt = "48@!alsd";
		// $password = "toto";
		// $password_crypt = sha1(sha1($password).$salt);
		if (function_exists('sha1')){	// Only in PHP 4.3.0+
			return sha1($word);
		} elseif (function_exists('mhash')){ // Only if Mhash library is loaded
			return bin2hex(mhash(MHASH_SHA1, $word));
		} else {
			return md5($word);
		}
	}
	public function num($num){
		if (!preg_match("/^[0-9]+$/",trim($num))) exit("number entry incorrect !");
		return $num;
	}
	public function word($word){
		if (!preg_match("/^[A-Za-z0-9_\/\.\:]+$/",trim($word))) exit("word entry incorrect !");
		return $word;
	}
	public function safe($val=null){
		if ( get_magic_quotes_gpc() ) $val = stripslashes($val);
		$dbLink = mysqli_connect(HOSTMYSQL,USERMYSQL,PASSMYSQL,BASEMYSQL) or die("Error " . mysqli_error($link)); 
		$result = mysqli_real_escape_string($dbLink,$val);
		mysqli_close($dbLink);
		return $result;
	}
	public function strWidthLeft($val=null,$size=128){
		$val = strip_tags(html_entity_decode(utf8_decode(trim($val))));
		if (strlen($val) > $size){
			$result = substr($val,0,$size);
			$words = array_filter(explode(" ",$result));
			// delete last word fragment
			if (count($words) > 1) array_pop($words);
			$result = implode($words," ")."...";
		} else {
			$result = $val;
		}
		return utf8_encode($result);
	}
	public function strWidth($val=null,$size=64){
		$val = strip_tags(html_entity_decode(utf8_decode(trim($val))));
		$stringLen = strlen($val);
		if ( $stringLen > $size ){
			$e = floor(($size-2) / 2);
			$result = substr($val,0,$e)."..".substr($val,-$e);
		} else {
			$result = $val;
		}
		if (strlen($result) < $size) $result = $result.str_repeat("&nbsp;",$size-strlen($result));
		return utf8_encode($result);
	}
	public function uly_htmlentities($val=Null){
		return htmlentities($val,ENT_QUOTES,"UTF-8");
	}
	public function uCredits($firstLine=True,$secondLine=True){
		$t = new Translate();
		$firstLine = ($firstLine)?$this->p($this->ahref("index.php?k=contact&amp;v=0",$t->w("Contact website"))." ".$this->ahref("login.php",$t->w("Login")),"class='credits'"):"";
		$secondLine = ($secondLine)?$this->p($this->ahref("http://ulyxex.logz.org",$t->wr("Made with Ulyxex").VERSION)." ".$this->ahref("http://artlibre.org/licence/lal/en",$t->w("Copyleft Free Art License")),"class='credits'"):"";
		return $firstLine.$secondLine;
	}
	public function countQ(){
		return $this->p("queries = ".$_SESSION['countqueries']);
    }
	public function fmt($val){
		return sprintf("%'-4d",$val);
	}
	public function print_rr($arr=array()){
		echo "<pre>",print_r($arr,true),"</pre>";
	}
	public function root_url($val=null){
		$script = isset($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF']:null;
		$script = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME']:null;
		$script = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI']:null;
		if ( preg_match("/\//",$script) ){
			$relativPath = array();
			$relativPath = explode("/",$script);
			array_pop($relativPath);
			$localDir = implode("/",$relativPath);
		} else {
			$localDir = "";
		}
		if (isset($_SERVER['HTTP_HOST'])){
			$result = "http://".$_SERVER['HTTP_HOST'].$localDir."/"; 
		} elseif ( isset($_SERVER['SERVER_NAME']) ){
			$result = "http://".$_SERVER['SERVER_NAME'].$localDir."/";
		} else {
			$result = $localDir."/";
		}
		if (!empty($val)) $result .= $val;
		return $result;
	}
}
?>
