<?php
/* Ulyxex version 1.0.0 */
require_once("pages/core/ulyxex.php");
require_once("pages/core/translate.php");
require_once("pages/core/html.php");
define("L",					0);
define("VERSION",			"1.0.0");

/****************************************/
/* page elements						*/
$h = new Html();
$t = new Translate();
$css = $h->css("css/view_style.css","external");
$meta = $h->meta("Content-Type","text/html; charset=UTF-8");
$title = $h->title("install ulyxex");
$head = $h->head($meta.$css.$title);

$topPage = $h->p("web site ".$h->ahref($h->root_url(),$h->root_url()));
$data = $h->h2("install ulyxex");


if (isset($_POST['host']) && isset($_POST['database']) && isset($_POST['user']) && isset($_POST['prefix']) && isset($_POST['adminpassword'])) {
	$data .= $h->h3("don't forget to delete \"intall.php\" after installation","style='color:red'");
	
	$sqlQuieries = array();
	$hostMySql = $_POST['host'];
	$baseMySql = $_POST['database'];
	$userMySql = $_POST['user'];
	
	if (isset($_POST['sqlpassword'])) {
		$passMySql = $_POST['sqlpassword'];
	} else {
		$passMySql = ""; // avoid to crypt empty field
	}
	
	$prefixTableMySql = $_POST['prefix'];
	$adminPassword = $h->crypt($_POST['adminpassword']);
	
	/* Constants							*/
	define("HOSTMYSQL",			$hostMySql);
	define("BASEMYSQL",			$baseMySql);
	define("USERMYSQL",			$userMySql);
	define("PASSMYSQL",			$passMySql);

	// Base de données: 'ulyxex'

	// Structure de la table 'articles'
	$sqlQuieries[] = <<<SQLVAL
CREATE DATABASE IF NOT EXISTS $baseMySql DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
USE $baseMySql;
SQLVAL;
	
	$table = $prefixTableMySql."_articles";
	$sqlQuieries[] = <<<SQLVAL
CREATE TABLE IF NOT EXISTS $table (
  ID mediumint(6) NOT NULL AUTO_INCREMENT,
  DATE datetime NOT NULL,
  SUBJECT text NOT NULL, 
  CONTENT mediumtext NOT NULL,
  HIDE tinyint(1) NOT NULL,
  PAGEID mediumint(6) NOT NULL, 
  USERID mediumint(6) NOT NULL,
  PRIMARY KEY (ID),
  FULLTEXT KEY SUBJECT (SUBJECT)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;
SQLVAL;
	
	// Contenu de la table 'uly_articles'
	$sqlQuieries[] = <<<SQLVAL
INSERT INTO $table (ID, SUBJECT, USERID, DATE, CONTENT, HIDE, PAGEID) VALUES
(1, 'hello', 1, '2014-05-29 12:05:44', '<p>hello wold</p>', 0, 1);
SQLVAL;
	
	// Structure de la table 'home_params'
	$table = $prefixTableMySql."_home_params";
	$sqlQuieries[] = <<<SQLVAL
CREATE TABLE IF NOT EXISTS $table (
  ID mediumint(9) NOT NULL AUTO_INCREMENT,
  PAGEID mediumint(6) NOT NULL,
  SANDBOXID mediumint(6) NOT NULL,
  MAIL mediumtext NOT NULL,
  PRIMARY KEY (ID)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;
SQLVAL;
 
	// Contenu de la table 'home_params'
		$sqlQuieries[] = <<<SQLVAL
INSERT INTO $table (ID, PAGEID, MAIL, SANDBOXID) VALUES
(1, 1, 'none@none.org', 2);
SQLVAL;
 
	// Structure de la table 'links'
	$table = $prefixTableMySql."_links";
	$sqlQuieries[] = <<<SQLVAL
CREATE TABLE IF NOT EXISTS $table (
  ID mediumint(6) NOT NULL AUTO_INCREMENT,
  DATE datetime NOT NULL,
  NAME mediumtext NOT NULL,
  DESCRIPTION mediumtext NOT NULL, 
  LINK mediumtext NOT NULL,
  HIDE tinyint(1) NOT NULL,
  USERID mediumint(6) NOT NULL,
  PRIMARY KEY (ID),
  FULLTEXT KEY NAME (NAME)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
SQLVAL;
 
	// Structure de la table 'pages'
	$table = $prefixTableMySql."_pages";
	$sqlQuieries[] = <<<SQLVAL
CREATE TABLE IF NOT EXISTS $table (
  ID mediumint(6) NOT NULL AUTO_INCREMENT,
  DATE datetime NOT NULL,
  NAME mediumtext NOT NULL,
  DESCRIPTION mediumtext NOT NULL,
  PAGEHEAD mediumtext NOT NULL,
  PARENTID mediumint(6) NOT NULL DEFAULT '0',
  SORTSTYLE tinyint(1) NOT NULL DEFAULT '0',
  HIDE tinyint(1) NOT NULL,
  USERID mediumint(6) NOT NULL,
  PRIMARY KEY (ID),
  FULLTEXT KEY NAME (NAME)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
SQLVAL;
 
	// Contenu de la table 'pages'
	$sqlQuieries[] = <<<SQLVAL
INSERT INTO $table (ID, NAME, DESCRIPTION, HIDE, USERID) VALUES
(1, 'Home', 'Description', 0, 1),
(2, 'SANDBOX', 'Training category', 1, 1);
SQLVAL;
 
	// Structure de la table 'users'
	$table = $prefixTableMySql."_users";
	$sqlQuieries[] = <<<SQLVAL
CREATE TABLE IF NOT EXISTS $table (
  ID mediumint(6) NOT NULL AUTO_INCREMENT,
  DATE datetime NOT NULL,
  USERNAME text NOT NULL,
  DESCRIPTION longtext NOT NULL,
  MAIL mediumtext NOT NULL,
  USERLEVEL tinyint(1) NOT NULL,
  LOGIN mediumtext NOT NULL,
  PASSWORD mediumtext NOT NULL,
  USEROWNER mediumint(6) NOT NULL,
  PRIMARY KEY (ID),
  FULLTEXT KEY USERNAME (USERNAME)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;
SQLVAL;
 
	// Contenu de la table 'users'
	$sqlQuieries[] = <<<SQLVAL
INSERT INTO $table (ID, USERNAME, DESCRIPTION, MAIL, USERLEVEL, LOGIN, USEROWNER, PASSWORD) VALUES
(1, 'admin', 'super user to admin all.', 'none', 1, 'admin', 1, 'd033e22ae348aeb5660fc2140aec35850c4da997');
SQLVAL;
 
	// execute sql queries
	foreach($sqlQuieries as $query) {
		$dbLink = @mysqli_connect(HOSTMYSQL,USERMYSQL,PASSMYSQL,BASEMYSQL) or die("Error database connection aborted"); 
		$result = $dbLink->query($query);
		if ($result) {
			$data .= $h->p("DONE >>> ".$query, "style='color:green'");
		} else {
			$data .= $h->p("NOT >>>> ".$query, "style='color:red'");
		}
		mysqli_close($dbLink);
	}
	
	// write config file
	$Lines = file("config-example.php");
	foreach($Lines as $Line) {
		// change line if needed
		if (substr($Line, 0, 10) == '$hostMySql') {
			$Line = "\$hostMySql"." = \"".HOSTMYSQL."\";\n";
		}
		if (substr($Line, 0, 10) == '$baseMySql') {
			$Line = "\$baseMySql"." = \"".BASEMYSQL."\";\n";
		}
		if (substr($Line, 0, 10) == '$userMySql') {
			$Line = "\$userMySql"." = \"".USERMYSQL."\";\n";
		}
		if (substr($Line, 0, 10) == '$passMySql') {
			$Line = "\$passMySql"." = \"".PASSMYSQL."\";\n";
		}
		if (substr($Line, 0, 17) == '$prefixTableMySql') {
			$Line = "\$prefixTableMySql"." = \"".$prefixTableMySql."_\";\n";
		}
		$configData[] = $Line;
	}
	$File = fopen("config.php","w") or die("can't open file");
	foreach($configData as $Line) {
		fwrite($File, $Line);
	}
	fclose($File);
	
	$data .= $h->p("web site ".$h->ahref($h->root_url(),$h->root_url()));
} else {
	/****************************************/
	/* page data 							*/
	$inputs = $h->h3("don't forget to delete \"intall.php\" after installation","style='color:red'");	
	$inputs .= $h->h3("SQL settings :", "style='color:black'");
	$inputs .= $h->p($t->wr("sql host").$h->input("text","host","localhost","class='login'"));
	$inputs .= $h->p($t->wr("sql database").$h->input("text","database","essais","class='login'"));
	$inputs .= $h->p($t->wr("sql login").$h->input("text","user","root","class='login'"));
	$inputs .= $h->p($t->wr("sql password").$h->input("text","password","","class='login'"));
	$inputs .= $h->p("*****************************************");
	$inputs .= $h->h3("Ulyxex settings :", "style='color:black'");
	$inputs .= $h->p($t->wr("ulyxex tables prefix").$h->input("text","prefix","uly_".substr(strval(mt_rand()),0,5),"class='login'"));
	$inputs .= $h->p($t->wr("admin").$t->wr("password").$h->input("text","adminpassword","admin","class='login'"));
	$inputs .= $h->input("submit",null,"INSTALL");
	$data .= $h->form($inputs,"admin","post","install.php");
}
$bottomPage = $h->uCredits();

/****************************************/
/* show									*/
$body = $h->body($topPage.$data.$bottomPage);
$page = $h->html5($head.$body);

echo $page;
?>



