<?php
/* Ulyxex version 1.1.0 *****************/
/****************************************/
/* session always before header			*/
session_start();
$_SESSION['countqueries'] = 0;
/****************************************/
/* required								*/
require_once("config.php");
require_once("pages/core/translate.php");
require_once("pages/core/html.php");
require_once("pages/core/ulyxex.php");
require_once("pages/core/tree.php");
require_once("pages/core/admin.php");
/****************************************/
/* classes 								*/
$h = new Html();
$t = new Translate();
$o_admin = new Admin();
/****************************************/
/* login						 		*/
if (isset($_POST['login'])){
	$_SESSION['login'] = $h->word($_POST['login']);
	$_SESSION['password'] = $h->crypt($_POST['password']);
	list($_SESSION['userid'],$_SESSION['level']) = $o_admin->login($_SESSION['login'],$_SESSION['password']);
	$admin = 1;
} else if (isset($_SESSION['login']) && $_SESSION['login'] != Null){
	// you are logged in back end
	$admin = 1;
} else {
	exit("not allowed !");
}
/****************************************/
/* create menu (actions links)	 		*/
$Menu = new MenuLinks();
/****************************************/
/* catch action							*/
$action =(isset($_GET['action']))?$h->word($_GET['action']):null;
/* associated actions and scripts		*/
$actions = array(
	"home" 				=> "pages/admin_home.php",
	
	"articles" 			=> "pages/admin_articles.php",
	"add_article" 		=> "pages/admin_article_add.php",
	"modify_article" 	=> "pages/admin_article_modify.php",
	
	"links" 			=> "pages/admin_links.php",
	"add_link" 			=> "pages/admin_link_add.php",
	"modify_link" 		=> "pages/admin_link_modify.php",
	
	"pages" 			=> "pages/admin_pages.php",
	"add_page" 			=> "pages/admin_page_add.php",
	"modify_page" 		=> "pages/admin_page_modify.php",
	
	"users" 			=> "pages/admin_users.php",
	"add_user" 			=> "pages/admin_user_add.php",
	"modify_user" 		=> "pages/admin_user_modify.php",
	
	"multiples_uploads" => "pages/admin_files_uploads.php",
	"files"				=> "files/index.php"
);
/****************************************/
/* process								*/
if ( $action && array_key_exists($action,$actions) ){
	require_once($actions[$action]);
} else {
	/* default action */
	if ($_SESSION['level'] > 0 && $_SESSION['level'] <= 4){
		require_once("pages/admin_articles.php");
	} else {
		exit("error level !");
	}
}
/****************************************/
/* class for admin menu					*/
class MenuLinks {
	function __construct(){
		$h = New Html();
		$t = New Translate();
		$_ = array (
			"home"				=>$h->ahref("admin.php?action=home",$t->w("admin home"),"class='action'"),
			"articles"			=>$h->ahref("admin.php?action=articles",$t->w("articles"),"class='action'"),
			"uploads"			=>$h->ahref("admin.php?action=multiples_uploads",$t->w("uploads"),"class='action'"),
			"pages"				=>$h->ahref("admin.php?action=pages",$t->w("pages"),"class='action'"),
			"links"				=>$h->ahref("admin.php?action=links",$t->w("links"),"class='action'"),
			"users"				=>$h->ahref("admin.php?action=users",$t->w("users"),"class='action'"),
			"my_user_profile"	=>$h->ahref("admin.php?action=modify_user&amp;user=".$_SESSION['userid'],$t->w("my user profile"),"class='action'"),
			"help"				=>$h->ahref("http://ulyxex.logz.org/index.php?k=page&amp;v=3",$t->w("help"),"class='action'"),
			"login"				=>$h->ahref("login.php",$t->w("login"),"class='action'"),
			"logout"			=>$h->ahref("logout.php",$t->w("logout"),"class='action'")
		);
		// Level 1) can create users etc.
		$L1 = implode(" ",array($_["home"],$_["articles"],$_["uploads"],$_["pages"],$_["links"],$_["users"],$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		// Level 2) can create articles, 
		// pages and links
		$L2 = implode(" ",array(		   $_["articles"],$_["uploads"],$_["pages"],$_["links"],			$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		// Level 3) can create articles 
		// everywhere
		$L3 = implode(" ",array(		   $_["articles"],$_["uploads"],									$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		// Level 4) can create articles only 
		// in sandbox
		$L4 = implode(" ",array(		   $_["articles"],													$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		/* array			*/
		$_ = array("",$L1,$L2,$L3,$L4);
		$this->links = $_[$_SESSION['level']];
	}
}
?>
