<?php
/* Ulyxex version 0.1.5 *****************/
class Tree extends Ulyxex {
	function __construct(){
		$this->h = New Html();
		$this->t = New Translate();
		$this->parentOf = array();
		$this->name = array();
	}
	public function paths($hide=Null){
		$paths = array();
		if ($hide){
			$query = "SELECT ID,NAME,PARENTID FROM ".PAGES." WHERE HIDE != 1";
		} else {
			$query = "SELECT ID,NAME,PARENTID FROM ".PAGES;
		}
		
		$query = $this->q($query);
		
		while ( $line = $this->fetch($query) ){
			$this->parentOf[$line['ID']] = $line['PARENTID'];
			$this->name[$line['ID']] = $line['NAME'];
		}

		foreach($this->parentOf as $child => $parent){
			$ancestorId = 0;
			$ancestorsNames = array();
			if ($parent == 0){
				// if parent is home
				$lineage = "/".$this->name[$child]."/";
				$paths[$lineage] = $child; 
			} else {
				// if parent other than home exist
				// add parent
				if (isset($this->name[$parent])){
					// check if error in lineage
					if ( in_array($this->name[$parent],$ancestorsNames) ){print " error tree !";break;}
					$ancestorsNames[] = $this->name[$parent];
				}
				// if a gran parent exist
				if (array_key_exists($parent, $this->parentOf)){ 
					$ancestorId = $this->parentOf[$parent];
					// if others gran gran... parent exist
					while ($ancestorId != 0){
						if (isset($this->name[$ancestorId])){
							// check if error in lineage
							if ( in_array($this->name[$ancestorId],$ancestorsNames) ){print " error tree !";break;}
							$ancestorsNames[] = $this->name[$ancestorId];
						}
						
						if (isset($this->parentOf[$ancestorId]) && $this->parentOf[$ancestorId] != 0){ 
							$ancestorId = $this->parentOf[$ancestorId];
						} else {
							$ancestorId = 0;
						}
					}
					$ancestorsNames = array_reverse($ancestorsNames);
					$lineage = "/".implode("/",$ancestorsNames)."/".$this->name[$child]."/";
					$paths[$lineage] = $child; 
				}
				
			}
		}
		// $_ = array();
		// foreach($paths as $k=>$v){
			// $_[$this->h->strWidth($k,50)] = $v;
		// }
		// $paths = $_;
		return $paths;
	}
	public function pathsSelect($selected=Null,$root=1){
		$paths = $this->paths();
		ksort($paths);
		$options = array();
		if ($root) $options["ROOT/"] = 0;
		foreach($paths as $path => $idVal){
			$pathLevels = explode("/",$path);
			$path = "ROOT-";
			$path .= str_repeat("-",count($pathLevels)-3); // 3 for first "/", last "/" and array position
			array_pop($pathLevels);
			$path .= ">".array_pop($pathLevels);
			$options[$path.$this->h->comments($idVal)] = $idVal;
		}
		return $this->h->select($options,"parent",$selected);
	}
	public function pathTest($page=0,$parent=0){
		$paths = $this->paths();
		$lineage = explode("/",array_search($parent,$paths));
		return (in_array($this->name[$page],$lineage))?0:1;
	}
	public function pathPage($parent=0){
		$paths = $this->paths();
		return array_search($parent,$paths);
	}
	public function pagesNavigation($page=Null){
		$paths = $this->paths($hide=1); // prevent showing hide links
		ksort($paths);
		$pages_paths = array();
		$selectedPath = $page;
		$navigationTitle = "--".$this->t->w("Pages").str_repeat("-",20-strlen($this->t->w("Pages")));
		$linksTitle = "--".$this->t->w("Links").str_repeat("-",20-strlen($this->t->w("Links")));
		// pages
		$pages_paths[$navigationTitle] = "limit";
		foreach($paths as $path => $idVal){
			$pathLevels = explode("/",$path);
			$path = str_repeat("-",count($pathLevels)-3); // 3 for first "/", last "/" and array position
			if (count($pathLevels)-3 > 0) $path .= "> ";
			array_pop($pathLevels);
			$path .= array_pop($pathLevels);
			$pages_paths[$path.$this->h->comments($idVal)] = $idVal;
		}
		
		// links
		$query = "SELECT "."ID,NAME FROM ".LINKS." WHERE HIDE != 1 ORDER BY NAME";
		$query = $this->q($query);
		$link_paths = array();
		$separation = 1;
		while ( $line = $this->fetch($query) ){
				if ($separation){
					$link_paths[$linksTitle] = "limit";
				$separation = 0;
			}
			$link_paths["- ".$line['NAME']] = "link".$line['ID'];
		}
		$options = array_merge($pages_paths,$link_paths);
		$menu = $this->h->input("hidden","k","page").$this->h->selectOnChange($options,"v",$selectedPath)." ".$this->h->input("submit",null,"GO");
		return $this->h->form($menu,"navform","post","index.php");
	}
}  
?>