<?php
class Articles extends Admin {
	function __construct() {
		$this->h = New Html();
		$this->tr = New Translate();
		$this->pagePos = isset($_GET['pg'])?$this->h->num($_GET['pg']):0;
		$this->sortMethods = array("",ARTICLES.".DATE DESC",ARTICLES.".SUBJECT",ARTICLES.".PAGEID",ARTICLES.".USERID","");  
		$this->Select = " SELECT ".
							ARTICLES.".ID ARTID,".ARTICLES.".SUBJECT,".ARTICLES.".DATE,".ARTICLES.".HIDE,".
							USERS.".USERNAME,".USERS.".ID IDUSERID,".USERS.".USERLEVEL,".
							PAGES.".NAME,".PAGES.".ID PAGEID,".PAGES.".USERID USERPAGEID";
		$this->From = 	" FROM ".
							ARTICLES.
							" INNER JOIN ".PAGES. " ON ".ARTICLES.".PAGEID = ".PAGES.".ID".
							" INNER JOIN ".USERS." ON ".ARTICLES.".USERID = ".USERS.".ID";
		$this->SelectCount = 	" SELECT COUNT(".ARTICLES.".ID) AS NUM";
		$this->OrderSort = "";
		$this->Cond = array();
		if (!isset($_SESSION['admin_article_sort'])) $_SESSION['admin_article_sort'] = $this->sortMethods[1];
	}
	public function update_articles() {
		// empty form 
		if (count($_POST) == 1) return;
		
		$values = $_POST;
		foreach($values as $k=>$v) {
			if ( preg_match("/\_/",$k) ) {
				list($key,$id) = explode("_",$k);
				$formValues[$id][$key] = $v;
			}
		}
		foreach($formValues as $id=>$value) {
			$query = 0;
			if (isset($value['delete'])) {
				$query = "DELETE FROM ".ARTICLES." WHERE ID = ".$id;
				$query = $this->q($query);
			}
			if (isset($value['hide']) && $value['oldhide'] == 0) {
				$query = "UPDATE ".ARTICLES." SET HIDE = 1 WHERE ID = ".$id;
				$query = $this->q($query);
			} else if (!isset($value['hide']) && $value['oldhide'] == 1) {
				$query = "UPDATE ".ARTICLES." SET HIDE = 0 WHERE ID = ".$id;
				$query = $this->q($query);
			}
		}
		return $this->h->h3($this->tr->w("some values have been modified !"),"class='warning'");
	}
	public function list_articles() {
		$pgPos =($this->pagePos)?($this->pagePos - 1) * ADMINITEMSBYPAGE:0;
		$siteDat = $this->home_params();
		if (isset($_POST['sort'])) $_SESSION['admin_article_sort'] = $this->sortMethods[$_POST['sort']];
		if (isset($_GET['ownerFilter'])) $_SESSION['admin_articles_filter'] = ARTICLES.".USERID = ".$this->h->num($_GET['ownerFilter']);
		if (isset($_GET['pageFilter'])) $_SESSION['admin_articles_filter'] = ARTICLES.".PAGEID = ".$this->h->num($_GET['pageFilter']);
		if (isset($_POST['search_subject'])) $_SESSION['admin_articles_search_subject'] = " MATCH(".ARTICLES.".SUBJECT) AGAINST('".$this->h->safe($_POST['search_subject'])."') ";
		if (isset($_POST['reset'])) {
			if (isset($_SESSION['admin_articles_filter'])) $_SESSION['admin_articles_filter'] = "";
			if (isset($_SESSION['admin_article_sort'])) $_SESSION['admin_article_sort'] = $this->sortMethods[1];
			if (isset($_SESSION['admin_articles_search_subject'])) $_SESSION['admin_articles_search_subject'] = "";
		}
		$this->OrderSort = " ORDER BY ".$_SESSION['admin_article_sort']." LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		// 1) can create users etc.
		// 2) can create articles, pages and links
		// 3) can create articles everywhere
		// 4) can create articles only in sandbox
		switch ($_SESSION['level']) {
			case 1:
				// user level 1 can't edit others user level 1
				$this->Cond = array();
				if ($_SESSION['userid'] != 1) { // admin edit all
					$this->Cond[] = "(".USERS.".USERLEVEL > ".$_SESSION['level']." OR ".USERS.".ID = ".$_SESSION['userid'].")"; // all level 2, 3 and 4 user's articles, and user's articles 
					$this->Cond[] = USERS.".ID != 1"; // but not admin articles
				}
				if (isset($_SESSION['admin_articles_filter']) && !empty($_SESSION['admin_articles_filter'])) $this->Cond[] = $_SESSION['admin_articles_filter'];
				if (isset($_SESSION['admin_articles_search_subject']) && !empty($_SESSION['admin_articles_search_subject']) ) $this->Cond[] = $_SESSION['admin_articles_search_subject'];
				break;
			case 2:
				$this->Cond = array();
				$this->Cond[] = "(".USERS.".ID = ".$_SESSION['userid']." OR ".PAGES.".USERID = ".$_SESSION['userid'].")"; // user's articles and articles in user's pages
				$this->Cond[] = USERS.".ID != 1"; // but not admin articles
				if (isset($_SESSION['admin_articles_filter']) && !empty($_SESSION['admin_articles_filter']) ) $this->Cond[] = $_SESSION['admin_articles_filter'];
				if (isset($_SESSION['admin_articles_search_subject']) && !empty($_SESSION['admin_articles_search_subject']) ) $this->Cond[] = $_SESSION['admin_articles_search_subject'];
				break;
			case 3:
				$this->Cond = array();
				$this->Cond[] = ARTICLES.".USERID = ".$_SESSION['userid']; // user's articles only
				if (isset($_SESSION['admin_articles_search_subject']) && !empty($_SESSION['admin_articles_search_subject']) ) $this->Cond[] = $_SESSION['admin_articles_search_subject'];
				break;
			case 4:
				$this->Cond = array();
				$this->Cond[] = ARTICLES.".USERID = ".$_SESSION['userid']; // user's articles only
				if (isset($_SESSION['admin_articles_search_subject']) && !empty($_SESSION['admin_articles_search_subject']) ) $this->Cond[] = $_SESSION['admin_articles_search_subject'];
				break;
		}
		$query = $this->Select.$this->From.$this->Where($this->Cond).$this->OrderSort;
		$query = $this->q($query);
		
		$result = "";
		
		$sort = array($this->tr->w("date")=>1,$this->tr->w("subject")=>2,$this->tr->w("page")=>3,$this->tr->w("user")=>4);
		$type = array_search($_SESSION['admin_article_sort'],$this->sortMethods);
		$sortForm = $this->h->p($this->h->select($sort,"sort",$type)." ".$this->h->input("submit","",$this->tr->w("sort/group by")));
		$result .= $this->h->form($sortForm,"sort","post","admin.php?action=articles");
		
		$searchForm = $this->search_form("search_subject","search subject","articles");
		$goIdForm = $this->go_id("art","modify_article");
		$resetForm = $this->reset_form("articles");
		$result .= $searchForm.$goIdForm.$resetForm;
		
		$artListSubmit = $this->h->p($this->h->input("submit","",$this->tr->w("update all")));
		$artList = $this->h->h3($this->tr->w("articles list"));
		$artList .= $this->h->input("hidden","update",1);
		
		while ( $line = $this->fetch($query) ) {
			$by = $this->tr->w("by-").$this->h->ahref("admin.php?action=articles&amp;ownerFilter=".$line['IDUSERID'],$this->h->strWidth($line['USERNAME'],16),"class='action' title='".$this->h->uly_htmlentities($line['USERNAME'])."'");
			
			$page = $this->tr->wr("page").$this->h->ahref("admin.php?action=articles&amp;pageFilter=".$line['PAGEID'],$this->h->strWidth($line['NAME'],20),"class='action' title='".$this->h->uly_htmlentities($line['NAME'])."'");
			
			$date = $this->h->input("text","text",$line['DATE'],"size='10' readonly");
			
			$checked = ($line['HIDE'])?" checked=\"checked\"":null;
			$hide = $this->tr->wr("hide").$this->h->input("checkbox","hide_".$line['ARTID'],"on",$checked).
			$this->h->input("hidden","oldhide_".$line['ARTID'],$line['HIDE']);
			
			$modify = $this->h->ahref("admin.php?action=modify_article&amp;art=".$line['ARTID'],$this->tr->w("modify"),"class='action'");
			
			$subject = $this->h->strWidth(strip_tags($line['SUBJECT']),32);
			
			$view = $this->tr->wr("title").$this->h->ahref("index.php?k=article&amp;v=".$line['ARTID'],$subject,"class='action' target=_blank title='".$this->h->uly_htmlentities(strip_tags($line['SUBJECT']))."'");
			
			$delete = $this->tr->wr("delete").$this->h->input("checkbox","delete_".$line['ARTID'],"on");
			
			$id = "id ".$this->h->fmt($line['ARTID']);
			
			$_ = array($this->aFrame($id),$date,$this->aFrame($hide),$modify,$this->aFrame($delete),$view,$page,$by);
			$content = implode(" ",$_);
			$artList .= $this->h->p($content);
		}

		$nextPages = $this->next_pages();
		$artList = $artListSubmit.$artList.$nextPages.$artListSubmit;
		$result .= $this->h->form($artList,"articles","post","admin.php?action=articles&amp;pg=".$this->pagePos);
		return $result;
	}
	public function next_pages(){
		$query = $this->SelectCount.$this->From.$this->Where($this->Cond);
		$query = $this->q($query);
		$line = $this->fetch($query);
		$pagesNumbers = new NextPages($line['NUM'],"action=articles");
		$result = $this->h->p($pagesNumbers->numbers());
		$result .= $this->h->p("(".$this->tr->wr("total articles")." = ".$line['NUM'].")");
		return $result;
	}
}
?>