<?php
/****************************************/
/* clean all sessions 					*/
/* session always before header			*/
session_start();
/* erase all sessions					*/
$_SESSION = array();
/* delete cookies						*/
if (isset($_COOKIE[session_name()])) {
	setcookie(session_name(), '', time()-42000, '/');
}
/* destroy sessions						*/
session_destroy();
/****************************************/
/* required								*/
require("pages/core/html.php");
/****************************************/
/* page elements						*/
$h = new Html();
$css = $h->css("css/view_style.css","external");
$meta = $h->meta("Content-Type","text/html; charset=UTF-8");
$title = $h->title("login");
$head = $h->head($meta.$css.$title);

$topPage = $h->p($h->root_url());

$bottomPage = $h->p($h->ahref("http://ulyxex.logz.org","Made with Ulyxex")." ".$h->ahref("http://artlibre.org/licence/lal/en","Copyleft Free Art License"));
/****************************************/
/* page data							*/	
$inputs = $h->p("login ".$h->input("text","login","login ?","class='login'"));
$inputs .= $h->p("pass ".$h->input("password","password",null,"class='login'")." ".$h->input("submit",null,"GO") );
$data = $h->form($inputs,"admin","post","admin.php");
/****************************************/
/* show									*/
$body = $h->body($topPage.$data.$bottomPage);
$page = $h->html5($head.$body);

echo $page;
?>