<?php
/****************************************/
/* session always before header			*/
session_start();
$_SESSION['countqueries'] = 0;
/****************************************/
/* required								*/
include("config.php");
require("pages/core/translate.php");
require("pages/core/html.php");
require("pages/core/ulyxex.php");
require("pages/core/admin.php");
require("pages/core/tree.php");
/****************************************/
/* classes 								*/
$h = new Html();
$tr = new Translate();
$o_admin = new Admin();
/****************************************/
/* login						 		*/
if (isset($_POST['login'])) {
	$_SESSION['login'] = $h->word($_POST['login']);
	$_SESSION['password'] = $h->crypt($_POST['password']);
	$_SESSION['level'] = $o_admin->login($_SESSION['login'],$_SESSION['password']);
	$_SESSION['userid'] = $o_admin->user_id($_SESSION['login']);
	$admin = 1;
} else if (isset($_SESSION['login']) && $_SESSION['login'] != Null) {
	// you are in back end
	$admin = 1;
} else {
	exit("not allowed !");
}
/****************************************/
/* create menu (actions links)	 		*/
$o_actions = new MenuActions($_SESSION['userid']);
$actionsLinks = $o_actions->links;
/****************************************/
/* catch action							*/
$action =(isset($_GET['action']))?$h->word($_GET['action']):null;
/* associated actions and scripts		*/
$actions = array(
	"home" 				=> "pages/admin_home.php",
	
	"articles" 			=> "pages/admin_articles.php",
	"add_article" 		=> "pages/admin_article_add.php",
	"modify_article" 	=> "pages/admin_article_modify.php",
	
	"links" 			=> "pages/admin_links.php",
	"add_link" 			=> "pages/admin_link_add.php",
	"modify_link" 		=> "pages/admin_link_modify.php",
	
	"pages" 			=> "pages/admin_pages.php",
	"add_page" 			=> "pages/admin_page_add.php",
	"modify_page" 		=> "pages/admin_page_modify.php",
	
	"users" 			=> "pages/admin_users.php",
	"add_user" 			=> "pages/admin_user_add.php",
	"modify_user" 		=> "pages/admin_user_modify.php",
	
	"multiples_uploads" => "pages/admin_files_uploads.php",
	"files"				=> "files/index.php"
);

/****************************************/
/* process								*/
if ( $action && array_key_exists($action,$actions) ) {
	require($actions[$action]);
} else {
	/* default action */
	if ($_SESSION['level'] > 0 && $_SESSION['level'] < 5) {
		require("pages/admin_articles.php");
	} else {
		exit("error level !");
	}
}
/****************************************/
/* class for admin menu					*/
class MenuActions {
	function __construct($userId=Null) {
		$h = New Html();
		$tr = New Translate();
		$_ = array (
			"home"				=>$h->ahref("admin.php?action=home",$tr->w("admin home"),"class='action'"),
			"articles"			=>$h->ahref("admin.php?action=articles",$tr->w("articles"),"class='action'"),
			"uploads"			=>$h->ahref("admin.php?action=multiples_uploads",$tr->w("uploads"),"class='action'"),
			"pages"				=>$h->ahref("admin.php?action=pages",$tr->w("pages"),"class='action'"),
			"links"				=>$h->ahref("admin.php?action=links",$tr->w("links"),"class='action'"),
			"users"				=>$h->ahref("admin.php?action=users",$tr->w("users"),"class='action'"),
			"my_user_profile"	=>$h->ahref("admin.php?action=modify_user&user=".$userId,$tr->w("my user profile"),"class='action'"),
			"help"				=>$h->ahref("http://ulyxex.logz.org/index.php?k=page&amp;v=3",$tr->w("help"),"class='action'"),
			"login"				=>$h->ahref("login.php",$tr->w("login"),"class='action'"),
			"logout"			=>$h->ahref("logout.php",$tr->w("logout"),"class='action'")
		);
		// Level 1) can create users etc.
		$L1 = implode(" ",array($_["home"],$_["articles"],$_["uploads"],$_["pages"],$_["links"],$_["users"],$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		// Level 2) can create articles, 
		// pages and links
		$L2 = implode(" ",array(		   $_["articles"],$_["uploads"],$_["pages"],$_["links"],			$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		// Level 3) can create articles 
		// everywhere
		$L3 = implode(" ",array(		   $_["articles"],$_["uploads"],									$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		// Level 4) can create articles only 
		// in sandbox
		$L4 = implode(" ",array(		   $_["articles"],													$_["my_user_profile"],$_["help"],$_["login"],$_["logout"] ));
		/* array								*/
		$this->links = array("",$L1,$L2,$L3,$L4);
	}
}
?>
