<?php
/****************************************/
/* clean all sessions 					*/
/* session always before header			*/
session_start();

/* erase all sessions					*/
$_SESSION = array();

/* delete cookies						*/
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time()-42000, '/');
}

/* destroy sessions						*/
session_destroy();

/****************************************/
/* required								*/
require("pages/code/html.php");
/****************************************/
/* page elements						*/
$h = new Html();
$css = $h->css("css/view_style.css","external");
$meta = $h->meta("Content-Type","text/html; charset=UTF-8");
$title = $h->title("logout");
$head = $h->head($meta.$css.$title);

$topPage = $h->h1("logout done");

$bottomPage = $h->p($h->ahref("http://ulyxex.logz.org","Made with Ulyxex")." ".$h->ahref("http://artlibre.org/licence/lal/en","Copyleft Free Art License"));

/****************************************/
/* page data							*/	
$root_url = $h->root_url();
$data = $h->h3($h->ahref("index.php","go to ".$root_url));

/****************************************/
/* show									*/
$body = $h->body($topPage.$data.$bottomPage);
$page = $h->html5($head.$body);
print $page;
?>