<?php
/****************************************/
/* session always before header			*/
session_start();
/****************************************/
/* required								*/
include("config.php");
require("pages/code/translate.php");
require("pages/code/html.php");
require("pages/code/ulyxex.php");
require("pages/code/admin.php");
require("pages/code/tree.php");
$h = new Html();
$tr = new Translate();
$o_admin = new Admin();

/****************************************/
/* login						 		*/
if (isset($_POST['login'])) {
	$_SESSION['login'] = $h->word($_POST['login']);
	$_SESSION['password'] = $h->crypt($_POST['password']);
	$_SESSION['level'] = $o_admin->login($_SESSION['login'],$_SESSION['password']);
	$_SESSION['userid'] = $o_admin->user_id($_SESSION['login']);
} else if (isset($_SESSION['login'])) {
	// pass
} else {
	exit;
}

/****************************************/
/* catch action							*/
$action =(isset($_GET['action']))?$h->word($_GET['action']):null;
/* associated actions and scripts		*/
$actions = array(
	"admin_home" 		=> "pages/admin_home.php",
	
	"articles" 			=> "pages/admin_articles.php",
	"add_article" 		=> "pages/admin_article_add.php",
	"modify_article" 	=> "pages/admin_article_modify.php",
	
	"links" 			=> "pages/admin_links.php",
	"add_link" 			=> "pages/admin_link_add.php",
	"modify_link" 		=> "pages/admin_link_modify.php",
	
	"pages" 			=> "pages/admin_pages.php",
	"add_page" 			=> "pages/admin_page_add.php",
	"modify_page" 		=> "pages/admin_page_modify.php",
	
	"users" 			=> "pages/admin_users.php",
	"add_user" 			=> "pages/admin_user_add.php",
	"modify_user" 		=> "pages/admin_user_modify.php",
	
	"multiples_uploads" => "pages/admin_files_uploads.php",
	"files"				=> "files/index.php"
);

/****************************************/
/* process								*/
/* you are in admin						*/
$admin = 1;

if ( $action && array_key_exists($action,$actions) ) {
	require($actions[$action]);
} else {
	/* default action */
	if ($_SESSION['level'] == 1) {
		require("pages/admin_pages.php");
	} else if ($_SESSION['level'] == 2) {
		require("pages/admin_articles.php");
	} else if ($_SESSION['level'] == 3) {
		require("pages/admin_articles.php");
	} else if ($_SESSION['level'] == 4) {
		require("pages/admin_articles.php");
	} else {
		exit("no level");
	}
}
?>