<?php
class CodeHtml {
	public function html5($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "<!DOCTYPE HTML>\n";
		$result .= "<html".$params.">";
		$result .= $val."\n</html>";
		return $result;
	}
	public function html4($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
		$result .= "<html".$params.">";
		$result .= $val."\n</html>";
		return $result;
	}
	public function xhtml($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?".">\n";
		$result .= "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/html51/DTD/html51-transitional.dtd\">\n";
		$result .= "<html xmlns=\"http://www.w3.org/1999/html5\"".$params.">";
		$result .= $val."\n</html>\n";
		return $result;
	}
	public function body($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<body".$params.">".$val."\n</body>";
		return $result;
	}
	public function head($val=null) {
		$result = "\n<head>".$val."\n</head>";
		return $result;
	}
	public function meta($http=null,$content=null) {
		$result = "\n<meta http-equiv=\"".$http."\" content=\"".$content."\" />";
		if ($http) return $result;
	}
	public function title($val=null) {
		$result = "\n<title>".$val."</title>";
		if ($val) return $result;
	}
	public function h1($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<h1".$params.">".$val."\n</h1>";
		if ($val) return $result;
	}
	public function h2($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<h2".$params.">".$val."\n</h2>";
		if ($val) return $result;
	}
	public function h3($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<h3".$params.">".$val."\n</h3>";
		if ($val) return $result;
	}
	public function p($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<p".$params.">".$val."\n</p>";
		if ($val) return $result;
	}
	public function pbr($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$val = nl2br($val);
		$result = "\n<pre".$params.">".$val."\n</pre>";
		if ($val) return $result;
	}
	function bold($val=null) {
		$result = "<strong>".$val."</strong>";
		if ($val) return $result;
	}
	public function pre($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<pre".$params.">".$val."\n</pre>";
		if ($val) return $result;
	}
	public function div($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<div".$params.">".$val."\n</div>";
		if ($val) return $result;
	}
	public function span($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "\n<span".$params.">".$val."\n</span>";
		if ($val) return $result;
	}
	public function label($val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "<label".$params.">".$val."</label>";
		if ($val) return $result;
	}
	public function comments($val=null) {
		$result = "<!--".$val."-->\n";
		if ($val) return $result;
	}
	public function br($val=null) {
		$result = $val."<br />\n";
		return $result;
	}
	public function ahref($target=null,$val=null,$params=null) {
		if ($params) {$params = " ".$params;}
		$result = "<a href=\"".$target."\"".$params.">".$val."</a>";
		if ($val && $target) return $result;
		return $result;
	}
	public function css($val=null,$externe=null){
		$result = "";
		if ($val!=null && $externe==null) {
			$result = "\n<style type=\"text/css\">\n".$val."</style>";
		} elseif($val!=null && $externe!=null) {
			$result = "\n<link href=\"".$val."\" rel=\"stylesheet\" type=\"text/css\" />";
		}
		if ($val) return $result;
	}
	public function form($val="",$name=null,$method=null,$action=null) {
		$result = "";
		$result = "\n<form ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		if ($method != null) $result .= "method=\"".$method."\" ";
		if ($action != null) $result .= "action=\"".$action."\" ";
		$result .= ">";
		$result .= $val;
		$result .= "\n</form>";
		if ($val) return $result;
	}
	public function textarea($val=null,$name=null,$sizes=array(4,80),$params=null) {
		$result = "\n<textarea ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		if ($sizes != null) $result .= "rows=\"".$sizes[0]."\" cols=\"".$sizes[1]."\" ";
		if ($params != null) $result .= $params;
		$result .= ">";
		$result .= wordwrap($val,80,"\n",true);
		$result .= "</textarea>";
		return $result;
	}
	public function input($type=null,$name=null,$value=null,$params=null) {
		$result = "";
		$result = "<input ";
		if ($type != null) $result .= "type=\"".$type."\" ";
		if ($name != null) $result .= "id=\"".$name."\" name=\"".$name."\" ";
		if ($value != null) $result .= "value=\"".$value."\" ";
		if ($params != null) $result .= $params." ";
		$result .= "/>";
		if ($type) return $result;
	}
	public function select($elements=null,$name=null,$selected=null) {
		$select = array();
		$firstOption = "";
		foreach($elements as $item=>$value){
			if ($value == $selected) {
				$firstOption =  "<option value=\"".$value."\" selected=\"selected\">".$item."</option>"; 
			} else {
				$select[] =  "<option value=\"".$value."\">".$item."</option>"; 
			}
		}
		array_unshift($select,$firstOption);
		$result = implode("\n",$select);
		if ($name) {$name = " id=\"".$name."\" name=\"".$name."\"";}
		$result = "\n<select".$name.">".$result."\n</select>";
		return $result;
	}
	public function root_url($val=null) {
		$script = isset($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF']:null;
		$script = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME']:null;
		$script = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI']:null;
		if ( preg_match("/\//",$script) ) {
			$relativPath = array();
			$relativPath = explode("/",$script);
			array_pop($relativPath);
			$localDir = implode("/",$relativPath);
		} else {
			$localDir = "";
		}
		
		if (isset($_SERVER['HTTP_HOST'])) {
			$result = "http://".$_SERVER['HTTP_HOST'].$localDir."/"; 
		} elseif ( isset($_SERVER['SERVER_NAME']) ) {
			$result = "http://".$_SERVER['SERVER_NAME'].$localDir."/";
		} else {
			$result = $localDir."/";
		}
		if (!empty($val)) $result .= $val;
		return $result;
	}
	public function crypt($word) {
		if (function_exists('sha1')) {	// Only in PHP 4.3.0+
			return sha1($word);
		} elseif(function_exists('mhash')) { // Only if Mhash library is loaded
			return bin2hex(mhash(MHASH_SHA1, $word));
		} else {
			return md5($word);
		}
	}
	public function num($num){
		if (!preg_match("/^[0-9]+$/",$num)) exit("num entry incorrect");
		return $num;
	}
	public function word($word){
		if (!preg_match("/^[A-Za-z0-9_]+$/",$word)) exit("word entry incorrect");
		return $word;
	}
	public function safe($val=null) {
		if ( get_magic_quotes_gpc() ) $val = stripslashes($val);
		// if ( 
			// preg_match("/\bunion\b/i",$val) ||
			// preg_match("/\bselect\b/i",$val) ||
			// preg_match("/\bwhere\b/i",$val)
		// ) exit;
		$dbLink = @mysql_connect(HOSTMYSQL,USERMYSQL,PASSMYSQL);
		if (function_exists('mysql_real_escape_string') && is_resource($dbLink)) {
			$result = mysql_real_escape_string($val);
		} else {
			$result = mysql_escape_string($val);
		}
		mysql_close($dbLink);
		return $result;
	}
}
?>