<?php
/****************************************/
/* session always before header			*/
session_start();
/****************************************/
/* required								*/
include("config.php");
require("scripts/class_codehtml.php");
require("scripts/admin_common.php");

$h = new CodeHtml();
$sql = new MySql();

/****************************************/
/* vars							 		*/
if (isset($_POST['login'])) {
	$_SESSION['login'] = $h->word($_POST['login']);
	$_SESSION['password'] = $h->crypt($_POST['password']);
	$_SESSION['level'] = $sql->login($_SESSION['login'],$_SESSION['password']);
	$_SESSION['userid'] = $sql->userid($_SESSION['login']);
} else if (isset($_SESSION['login'])) {
	// pass
} else {
	exit;
}

$action =(isset($_GET['action']))?$h->word($_GET['action']):null;
/****************************************/
/* associated actions and scripts		*/
$actions = array(
	"admin_site" => "scripts/admin_site.php",
	
	"articles" => "scripts/admin_articles.php",
	"add_article" => "scripts/admin_article_add.php",
	"modify_article" => "scripts/admin_article_modify.php",
	
	"categories" => "scripts/admin_categories.php",
	"add_category" => "scripts/admin_category_add.php",
	"modify_category" => "scripts/admin_category_modify.php",
	
	"users" => "scripts/admin_users.php",
	"add_user" => "scripts/admin_user_add.php",
	"modify_user" => "scripts/admin_user_modify.php",
);

/****************************************/
/* level 1 all privileges and website 	*/
/* parameters							*/
$actionsLinksLevel1 = 
	$h->ahref("admin.php?action=admin_site","admin site").
" ".$h->ahref("admin.php?action=articles","list articles").
" ".$h->ahref("admin.php?action=categories","list categories").
" ".$h->ahref("admin.php?action=users","list users").
" ".$h->ahref("login.php","reLogin").
" ".$h->ahref("logout.php","logout");
/* level 2 create categories and write	*/
/* articles everywhere 					*/
$actionsLinksLevel2 = 
	$h->ahref("admin.php?action=articles","list articles").
" ".$h->ahref("admin.php?action=categories","list categories").
" ".$h->ahref("admin.php?action=users","list users").
" ".$h->ahref("admin.php?action=modify_user","my user profile").
" ".$h->ahref("login.php","reLogin").
" ".$h->ahref("logout.php","logout");
/* level 3 create categories and write	*/
/* articles only in owner categories	*/
$actionsLinksLevel3 = 
	$h->ahref("admin.php?action=articles","list articles").
" ".$h->ahref("admin.php?action=categories","list categories").
" ".$h->ahref("admin.php?action=users","list users").
" ".$h->ahref("admin.php?action=modify_user","my user profile").
" ".$h->ahref("login.php","reLogin").
" ".$h->ahref("logout.php","logout");
/* level 4 only write articles in		*/
/* sandbox								*/
$actionsLinksLevel4 = 
	$h->ahref("admin.php?action=articles","list articles").
" ".$h->ahref("admin.php?action=modify_user","my user profile").
" ".$h->ahref("login.php","reLogin").
" ".$h->ahref("logout.php","logout");

$actionsLinks = array("",$actionsLinksLevel1,$actionsLinksLevel2,$actionsLinksLevel3,$actionsLinksLevel4);

/****************************************/
/* process								*/
/* you are in admin						*/
$admin = 1;

if ( $action && array_key_exists($action,$actions) ) {
	require($actions[$action]);
} else {
	if ($_SESSION['level'] == 1) {
		require("scripts/admin_categories.php");
	} else if ($_SESSION['level'] == 2) {
		require("scripts/admin_articles.php");
	} else if ($_SESSION['level'] == 3) {
		require("scripts/admin_articles.php");
	} else if ($_SESSION['level'] == 4) {
		require("scripts/admin_articles.php");
	} else {
		exit("user level");
	}
}
?>