<?php
class NextPages {
	public function __construct($catId) {
		$sql = new MySql();
		$this->items = $sql->totalItems($catId);
		$this->catId = $catId;
		
	}
	public function numbers($pgPos) {
		$h = new CodeHtml();
		/* total pages */
		$pages = $this->items/ARTICLESBYPAGE; 
		$pages++;
		$result = "";
		if ($pages > 2) {
			for($i=1;$i < $pages;$i++) {
				$num = $i?strval($i):"0";
				if ($i == $pgPos) {
					$result .= "(".$h->ahref("index.php?cat=".$this->catId."&amp;pg=".$num,$num).") ";
				} else {
					$result .= $h->ahref("index.php?cat=".$this->catId."&amp;pg=".$num,$num)." ";
				}
			}
		}
		return $result;
	}
}
class MySql {
	private function req($req=null) {
		$req = trim($req);
		$length = strlen($req);
		if ($req[($length-1)] != ";") $req .= ";";
		$dbLink = @mysqli_connect(HOSTMYSQL,USERMYSQL,PASSMYSQL,BASEMYSQL) or die("Error database connection aborted"); 
		$result = $dbLink->query($req);
		mysqli_close($dbLink);
		return $result;
	}
	public function totalItems($catId) {
		$req = "SELECT COUNT(ID) AS NUM FROM ".ARTICLES." WHERE CATEGORYID = ".$catId;
		$req = $this->req($req);
		$result = @mysqli_fetch_assoc($req);
		return $result['NUM'];	
	}
	public function exist_category($catId) {
		$req = "SELECT ID FROM ".CATEGORIES." WHERE ID = ".$catId;
		$req = $this->req($req);
		$result = @mysqli_fetch_assoc($req);
		return $result['ID'];	
	}
	public function article_hide($artId) {
		$req = "SELECT HIDE FROM ".ARTICLES." WHERE ID = ".$artId;
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		return $dat['HIDE'];
	}
	public function category_hide($catId) {
		$req = "SELECT HIDE FROM ".CATEGORIES." WHERE ID = ".$catId;
		$req = $this->req($req);
		$dat = @@mysqli_fetch_assoc($req);
		return $dat['HIDE'];
	}
	public function view_user($userId) {
		$h = New CodeHtml();
		$req = "SELECT ID,USERNAME,DESCRIPTION,MAIL,USERLEVEL FROM ".USERS." WHERE ID=".$userId;
		$req = $this->req($req);
		$result = "";
		$line = @mysqli_fetch_assoc($req);
		$result .= $h->h1($line['USERNAME']);
		$result .= $h->p($line['DESCRIPTION']);
		$result .= $h->p($line['MAIL']);
		return $result;
	}
	public function view_category($catId,$pgPos=0) {
		$h = New CodeHtml();
		if ($pgPos) $pgPos = ($pgPos - 1) * ARTICLESBYPAGE;
		if ($this->category_hide($catId) || $this->exist_category($catId) == null) {
			return $h->h3("no category !");
		} else {
			$req = "SELECT ".ARTICLES.".*,".USERS.".USERNAME FROM ".ARTICLES.",".USERS.
						" WHERE ".ARTICLES.".CATEGORYID=".$catId." AND ".
						ARTICLES.".HIDE = 0 AND ".
						USERS.".ID = ".ARTICLES.".USERID".
						" ORDER BY DATE DESC".
						" LIMIT ".$pgPos.",".ARTICLESBYPAGE;
						
			$req = $this->req($req);
			$result = "";
			while ( $line = @mysqli_fetch_assoc($req) ) {
				$result .= $h->h2($line['TITLE']);
				$result .= $h->pre($line['TEXT']);
				$result .= $h->p($h->ahref("index.php?user=".$line['USERID'],$line['USERNAME'])." , ".$line['DATE'].", ".$h->ahref("index.php?art=".$line['ID'],"url"));
			}
			return $result;
		}
	}
	public function view_article($artId) {
		$h = New CodeHtml();
		$req = "SELECT ".ARTICLES.".*,".USERS.".USERNAME FROM ".
						ARTICLES.",".USERS." WHERE ".
						ARTICLES.".ID=".$artId." AND ".
						ARTICLES.".HIDE = 0 AND ".
						USERS.".ID = ".ARTICLES.".USERID;";
						
		$req = $this->req($req);
		$line = @mysqli_fetch_assoc($req);
		$catDat = $this->cat_params($line['CATEGORYID']);
		
		if ($catDat['HIDE']) {
			return $h->h3("no article !");
		} else if ($this->article_hide($artId) || $line['ID'] == ""){
			return $h->h3("no article !");
		} else {
			$result = "";
			$result .= $h->h1($line['TITLE']);
			$result .= $h->pre($line['TEXT']);
			$result .= $h->p($h->ahref("index.php?user=".$line['USERID'],$line['USERNAME'])." , ".$line['DATE']);
			return $result;
		}
	}
	public function home_params() {
		$req = "SELECT * FROM ".PARAMS." WHERE ID=1;";
		$req = $this->req($req);
		$result = @mysqli_fetch_assoc($req);
		return $result;
	}
	public function cat_params($id) {
		$req = "SELECT ID,NAME,DESCRIPTION,HIDE,ASCIILOGO FROM ".CATEGORIES." WHERE ID=".$id;
		$req = $this->req($req);
		$result = @mysqli_fetch_assoc($req);
		return $result;
	}
	public function allCategories() {
		$home = $this->home_params();
		$req = "SELECT "."ID,NAME FROM ".CATEGORIES;
		$req = $this->req($req);
		$elements = array();
		while ( $line = @mysqli_fetch_assoc($req) ) {
			if ($line['ID'] == $home['CATEGORYID']) {
				$elements["(home) ".$line['NAME']] = $line['ID'];
			} else if ($line['ID'] == $home['SANDBOXID']) {
				// pass
			} else {
				$elements[$line['NAME']] = $line['ID'];
			}
		}
		$elements['files'] = "files";
		$h = New CodeHtml();
		$catId = isset($_GET['cat'])?$h->num($_GET['cat']):null;
		$menu = $h->p($h->select($elements,"cat",$catId).$h->input("submit",null,"GO"));
		$result = $h->form($menu,"menu","get","index.php");
		return $result;
	}
}
?>
