<?php
function print_rr($array=array()) {
	$result = "";
	$result = print_r($array,true);
	echo "<pre>";
	echo $result;
	echo "</pre>";
}
function short($val=null,$size=20) {
	$val = strip_tags($val);
	if ( strlen($val) > $size ) {
		$e = $size / 2;
		$result = substr($val,0,$e)." (..) ".substr($val,-$e);
	} else {
		$result = $val;
	}
	return $result;
}
class NextPages {
	public function __construct($table,$action) {
		$sql = new MySql();
		$this->items = $sql->totalItems($table);
		$this->action = $action;
		$this->pos= isset($_GET['pg'])?$_GET['pg']:0;
	}
	public function numbers() {
		$h = new CodeHtml();
		/* total pages */
		$pages = $this->items/ADMINITEMSBYPAGE; 
		$pages++;
		$result = "";
		if ($pages > 2) {
			for($i=1;$i < $pages;$i++) {
				$num = $i?strval($i):"0";
				if ($i == $this->pos) {
					$result .= "(".$h->ahref("admin.php?".$this->action."&amp;pg=".$num,$num).") ";
				} else {
					$result .= $h->ahref("admin.php?".$this->action."&amp;pg=".$num,$num)." ";
				}
			}
		}
		return $result;
	}
}
class Form {
	public function add_category_form() {
		$h = New CodeHtml();
		$content = $h->input("hidden","add",1);
		$content .= $h->p("hide = ".$h->input("checkbox","hide","on"));
		$content .= $h->p("name").$h->p($h->input("text","name","","size=".FIELDWIDTH));
		$content .= $h->p("description").$h->p($h->textarea("","description",array(8,FIELDWIDTH)));
		$content .= $h->p("ascii logo").$h->p($h->textarea("","asciilogo",array(8,FIELDWIDTH)));
		$content .= $h->p($h->input("submit","save","save"));
		$result = $h->form($content,"category","post","admin.php?action=add_category");
		return $result;
	}
	public function add_article_form() {
		$h = New CodeHtml();
		$sql = New MySql();
		$siteDat = $sql->home_params();
		$content = $h->input("hidden","add",1);
		$content .= $h->input("hidden","userid",$_SESSION['userid']);
		$content .=  $h->p("hide = ".$h->input("checkbox","hide","on"));
		$content .= ($_SESSION['level'] < 4)?  $h->p("choose category ".$sql->SelectUserCategories("categoryid",$siteDat['CATEGORYID'])): $h->p("SandBox").$h->input("hidden","categoryid",$siteDat['SANDBOXID']);
		$content .=  $h->p("title").$h->p($h->input("text","title","","size=".FIELDWIDTH));
		$content .=  $h->p("text").$h->p($h->textarea("","text",array(12,FIELDWIDTH)));
		$content .=  $h->p(" wordwrap 80 cols ".$h->input("checkbox","wordwrap","1","checked=\"checked\""));
		$content .=  $h->p($h->input("submit","save","save"));
		$result = $h->form($content,"article","post","admin.php?action=add_article");
		return $result;
	}
	public function add_user_form() {
		$h = New CodeHtml();
		$sql = New MySql();
		$content = $h->input("hidden","add",1);
		$content .= $h->p("login = ".$h->input("text","userlogin"));
		$content .= $h->p("password = ".$h->input("password","password"));
		$content .= $h->p("confirm password = ".$h->input("password","confirm"));
		$levels = array();
		for ($i=0;$i < (5 - $_SESSION['level']);$i++) {
			$x = 4 - $i;
			$levels["level ".$x] =  $x;
		}
		$content .= $h->p("level = ".$h->select($levels,"level",$_SESSION['level']));
		$content .= $h->p("name").$h->p($h->input("text","username"));
		$content .= $h->p("description").$h->p($h->textarea("","description",array(8,FIELDWIDTH)));
		$content .= $h->p("mail = ".$h->input("text","mail"));
		$content .= $h->p($h->input("submit","save","save"));
		$result = $h->form($content,"user","post","admin.php?action=add_user");
		return $result;
	}
}
class MySql {
	private function req($req=null) {
		$req = trim($req);
		$length = strlen($req);
		if ($req[($length-1)] != ";") $req .= ";";
		$dbLink = @mysqli_connect(HOSTMYSQL,USERMYSQL,PASSMYSQL,BASEMYSQL) or die("Error database connection aborted"); 
		$result = $dbLink->query($req);
		mysqli_close($dbLink);
		return $result;
	}
	public function login($login,$password) {
		$h = New CodeHtml();
		$req = "SELECT PASSWORD,USERLEVEL FROM ".USERS." WHERE LOGIN = '".$h->safe($login)."'";
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		if ($dat['PASSWORD'] == $password) {
			return $dat['USERLEVEL'];
		} else {
			exit("bad login & password");
		}
	}
	public function userid($login) {
		$req = "SELECT ID FROM ".USERS." WHERE LOGIN = '".$login."'";
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		return $dat['ID'];
	}
	public function user_params($userId) {
		$req = "SELECT * FROM ".USERS." WHERE ID = ".$userId;
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		return $dat;
	}
	public function catName($catId) {
		$req = "SELECT NAME FROM ".CATEGORIES." WHERE ID = ".$catId;
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		return $dat['NAME'];
	}
	public function art_params($artId) {
		$req = "SELECT ID,USERID,HIDE,CATEGORYID FROM ".ARTICLES." WHERE ID = ".$artId;
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		return $dat;
	}
	public function home_params() {
		$req = "SELECT * FROM ".PARAMS." WHERE ID = 1;";
		$req = $this->req($req);
		$result = @mysqli_fetch_assoc($req);
		return $result;
	}
	public function cat_params($id) {
		$req = "SELECT * FROM ".CATEGORIES." WHERE ID=".$id;
		$req = $this->req($req);
		$result = @mysqli_fetch_assoc($req);
		return $result;
	}
	public function totalItems($table) {
		$req = "SELECT COUNT(ID) AS NUM FROM ".$table;
		$req = $this->req($req);
		$result = @mysqli_fetch_assoc($req);
		return $result['NUM'];	
	}
	public function update_categories() {
		$values = $_POST;
		foreach($values as $k=>$v) {
			if ( preg_match("/\_/",$k) ) {
				list($key,$id) = explode("_",$k);
				$formValues[$id][$key] = $v;
			}
		}
		foreach($formValues as $id=>$value) {
			$req = 0;
			if ($value['oldname'] != $value['name']) {
				$req = "UPDATE ".CATEGORIES." SET NAME = '".$value['name']."' WHERE ID = ".$id;
				$req = $this->req($req);
			}
			if (isset($value['delete'])) {
				$req = "DELETE FROM ".CATEGORIES." WHERE ID = ".$id;
				$req = $this->req($req);
				$req = "DELETE FROM ".USERCATEGORIES." WHERE CATEGORYID = ".$id;
				$req = $this->req($req);
				$req = "DELETE FROM ".ARTICLES." WHERE CATEGORYID = ".$id;
				$req = $this->req($req);
			}
			if (isset($value['hide']) && $value['oldhide'] == 0) {
				$req = "UPDATE ".CATEGORIES." SET HIDE = 1 WHERE ID = ".$id;
				$req = $this->req($req);
			} else if (!isset($value['hide']) && $value['oldhide'] == 1) {
				$req = "UPDATE ".CATEGORIES." SET HIDE = 0 WHERE ID = ".$id;
				$req = $this->req($req);
				$req = "UPDATE ".ARTICLES." SET HIDE = 0 WHERE CATEGORYID = ".$id;
				$req = $this->req($req);
			}
		}
		$result = "some values have been modified !";;
		return $result;
	}
	public function list_categories($pgPos=0) {
		if ($pgPos) $pgPos = ($pgPos - 1) * ADMINITEMSBYPAGE;
		$reqLevel1 = 	"SELECT ".CATEGORIES.".*,".USERS.".USERNAME FROM ".CATEGORIES.",".USERS." WHERE ".
						USERS.".ID = ".CATEGORIES.".USERID ORDER BY ".CATEGORIES.".NAME LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		
		$reqLevel2 = 	"SELECT ".CATEGORIES.".* FROM ".CATEGORIES.",".USERCATEGORIES." WHERE ".
						USERCATEGORIES.".USERID = ".$_SESSION['userid']." AND ".
						USERCATEGORIES.".CATEGORYID = ".CATEGORIES.".ID ORDER BY ".CATEGORIES.".NAME LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		
		$reqLevel3 = $reqLevel2;
		
		$reqs = array("",$reqLevel1,$reqLevel2,$reqLevel3);
		$req = $this->req($reqs[$_SESSION['level']]);
		
		$h = New CodeHtml();
		$catList = $h->h3("categories list");
		$catList .= $h->p($h->input("submit","","save all"));
		$catList .= $h->input("hidden","update",1);
		$i = 1;
		while ( $line = @mysqli_fetch_assoc($req) ) {
			$content = $h->input("hidden","id",$line['ID']);
			$content .= $i." ";$i++;
			$content .= $h->ahref("admin.php?action=modify_category&amp;cat=".$line['ID'],"modify")." , ";
			$content .= $h->ahref("index.php?cat=".$line['ID'],"view","target=_blank")." , ";
			$params =  ($line['HIDE'])?" checked=\"checked\"":null;
			$content .= "hide = ".$h->input("checkbox","hide_".$line['ID'],"on",$params)." , ";
			$content .= $h->input("hidden","oldhide_".$line['ID'],$line['HIDE']);
			$content .= "name = ".$h->input("text","name_".$line['ID'],$line['NAME'],"size=35")." , ";
			$content .= $h->input("hidden","oldname_".$line['ID'],$line['NAME']);
			$content .= "delete = ".$h->input("checkbox","delete_".$line['ID'],"on")." , ";
			if ($_SESSION['level'] == 1) $content .= "{owner-".$line['USERNAME']."}";
			$catList .= $h->p($content);
		}
		$catList .= $h->p($h->input("submit","","save all"));
		$result = $h->form($catList,"categories","post","admin.php?action=categories");
		return $result;
	}
	public function list_categories_select($catId,$name) {
		$h = New CodeHtml();
		$req = "SELECT ".CATEGORIES.".ID,".CATEGORIES.".NAME FROM ".CATEGORIES;
		$req = $this->req($req);
		$elements = array();
		while ( $line = @mysqli_fetch_assoc($req) ) {
			if ($line['ID'] == $catId) {
				$elements[$line['NAME']] = $line['ID'];
			} else {
				$elements[$line['NAME']] = $line['ID'];
			}
		}
		$result = $h->select($elements,$name,$catId);
		return $result;
	}
	public function add_category() {
		$h = New CodeHtml();
		$hide = (isset($_POST['hide']))?1:0;
		$description = wordwrap($h->safe($_POST['description']),79,"\n",true);
		$req1 = "INSERT INTO ".CATEGORIES."  (NAME,DESCRIPTION,ASCIILOGO,HIDE,USERID) VALUES (".
											"'".$h->safe($_POST['name'])."','".$description."','".
											base64_encode($_POST['asciilogo'])."',".$hide.",".$_SESSION['userid'].");";
		$link = mysqli_connect(HOSTMYSQL, USERMYSQL, PASSMYSQL, BASEMYSQL);
		mysqli_query($link, $req1);
		$categoryId = mysqli_insert_id($link);
		$req2 = "INSERT INTO ".USERCATEGORIES."  (USERID,CATEGORYID) VALUES (".$_SESSION['userid'].",".$categoryId.");";
		mysqli_query($link, $req2);
		mysqli_close($link);
		$result = $h->h3("category ".$_POST['name']." created !");
		return $result;
	}
	public function update_category($catId) {
		$h = New CodeHtml();
		$hide = (isset($_POST['hide']))?1:0;
		$req = "UPDATE ".CATEGORIES." SET NAME = '".$h->safe($_POST['name'])."',".
									"DESCRIPTION = '".$h->safe($_POST['description'])."',".
									"ASCIILOGO = '".base64_encode($_POST['asciilogo'])."',".
									"HIDE = '".$hide."'".
									" WHERE ID = ".$catId;
		$req = $this->req($req);
		$result = $h->h3("category updated !");
		return $result;
	}
	public function data_category($catId) {
		$h = New CodeHtml();
		$reqLevel1 = 	"SELECT ".CATEGORIES.".* FROM ".CATEGORIES." WHERE ID = ".$catId;
		$reqLevel2 = 	"SELECT ".CATEGORIES.".* FROM ".CATEGORIES.",".USERCATEGORIES." WHERE ".
						USERCATEGORIES.".USERID = ".$_SESSION['userid']." AND ".
						USERCATEGORIES.".CATEGORYID = ".CATEGORIES.".ID"." AND ".
						CATEGORIES.".ID = ".$catId;

		if ($_SESSION['level'] > 1) {
			$req = $this->req($reqLevel2);
		} else {
			$req = $this->req($reqLevel1);
		}
		if ($req) {
			$dat = @mysqli_fetch_assoc($req);
			$content = $h->input("hidden","cat",$dat['ID']);
			$content .= $h->input("hidden","update",1);
			$params =  ($dat['HIDE'])?" checked=\"checked\"":null;
			$content .= $h->p("hide = ".$h->input("checkbox","hide","on",$params));
			$content .= $h->p("name").$h->p($h->input("text","name",$dat['NAME'],"size=".FIELDWIDTH));
			$content .= $h->p("description").$h->p($h->textarea($dat['DESCRIPTION'],"description",array(8,FIELDWIDTH)));
			$content .= $h->p("ascii logo").$h->p($h->textarea(base64_decode($dat['ASCIILOGO']),"asciilogo",array(8,FIELDWIDTH)));
			$content .= $h->p($h->input("submit","save","save"));
			$result = $h->form($content,"category","post","admin.php?action=modify_category");
			return $result;
		}
	}
	public function site_params() {
		$h = New CodeHtml();
		if ($_SESSION['level'] == 1) {
			$req = 	"SELECT ".PARAMS.".*,".CATEGORIES.".NAME FROM ".PARAMS.",".CATEGORIES.
					" WHERE ".PARAMS.".ID = 1 AND ".CATEGORIES.".ID = ".PARAMS.".CATEGORYID";
			$req = $this->req($req);
			$dat = @mysqli_fetch_assoc($req);
			$content = $h->input("hidden","paramId",$dat['ID']);
			$content .= $h->input("hidden","update",1);
			$content .= $h->p( " category name in use for home is \"".$h->bold($dat['NAME'])."\"");
			$content .= $h->p("choose new home category ".$this->list_categories_select($dat['CATEGORYID'],"catId"));
			$content .= $h->p(" website administrator mail ".$h->input("text","mail",$dat['MAIL']));
			$content .= $h->p(" choose new sandbox category ".$this->list_categories_select($dat['SANDBOXID'],"sandBoxId") );
			$content .= $h->p($h->input("submit","save","save all"));
			$form = $content;
			$result = $h->form($form,"category","post","admin.php?action=admin_site");
			return $result;
		}
	}
	public function update_site_params() {
		$h = New CodeHtml();
		$req = "UPDATE ".PARAMS." SET CATEGORYID = '".$_POST['catId'].
		"',MAIL = '".$h->safe($_POST['mail']).
		"',SANDBOXID = '".$h->num($_POST['sandBoxId'])."' WHERE ID = 1";
		$req = $this->req($req);
		$req = "UPDATE ".CATEGORIES." SET HIDE = 1 "." WHERE ID = ".$h->num($_POST['sandBoxId']);
		$req = $this->req($req);
		$result = $h->h3("params updated !");
		return $result;
	}
	public function add_article() {
		$h = New CodeHtml();
		$hide = (isset($_POST['hide']))?1:0;
		$now = time();
		$date = date("Y-m-d H:i:s",$now);
		/* in case of no category created		*/
		$siteDat = $this->home_params();
		$categoryId = isset($_POST['categoryid'])?$h->num($_POST['categoryid']):$siteDat['SANDBOXID'];
		$text = isset($_POST['wordwrap'])?wordwrap($h->safe($_POST['text']),79,"\n",true):$h->safe($_POST['text']);
		$req = "INSERT INTO ".ARTICLES."  (TITLE,USERID,DATE,TEXT,HIDE,CATEGORYID) VALUES (".
										"'".$h->safe($_POST['title'])."',".$h->num($_POST['userid']).",'".
										$date."','".$text."',".
										$h->num($hide).",".$categoryId.");";
		$req = $this->req($req);
		$result = $h->h3("article ".$_POST['title']." created !");
		return $result;
	}
	public function update_article($artId) {
		$h = New CodeHtml();
		$hide = (isset($_POST['hide']))?1:0;
		$now = time();
		$date = date("Y-m-d H:i:s",$now);
		/* in case of no category created		*/
		$siteDat = $this->home_params();
		$text = isset($_POST['wordwrap'])?wordwrap($h->safe($_POST['text']),79,"\n",true):$h->safe($_POST['text']);
		$categoryId = isset($_POST['categoryid'])?$h->num($_POST['categoryid']):$siteDat['SANDBOXID'];
		$req = "UPDATE ".ARTICLES."  SET TITLE = '".$h->safe($_POST['title'])."'".
										",USERID = ".$h->num($_POST['userid']).
										",DATE = '".$date."'".
										",TEXT = '".$text."'".
										",HIDE = ".$hide.
										",CATEGORYID = ".$categoryId.
										" WHERE ID = ".$artId;
		$req = $this->req($req);
		$result = $h->h3("article ".$_POST['title']." updated !");
		return $result;
	}
	public function data_article($artId) {
		$h = New CodeHtml();
		$siteDat = $this->home_params();
		$reqLevel1 = "SELECT * FROM ".ARTICLES." WHERE ID = ".$artId.";";
		$reqLevel2 = $reqLevel1;
		$reqLevel3 = "SELECT * FROM ".ARTICLES." WHERE ID = ".$artId." AND USERID = ".$_SESSION['userid'].";";
		$reqLevel4 = "SELECT * FROM ".ARTICLES." WHERE ID = ".$artId." AND CATEGORYID = ".$siteDat['SANDBOXID'].";";
		$reqs = array("",$reqLevel1,$reqLevel2,$reqLevel3,$reqLevel4);
		$req = $reqs[$_SESSION['level']];
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		if ($dat) {
			$content = $h->input("hidden","update",1);
			$content .= "id = ".$dat['ID'].$h->input("hidden","art",$dat['ID']);
			$params =  ($dat['HIDE'])?" checked=\"checked\"":null;
			$content .= $h->p("hide = ".$h->input("checkbox","hide","on",$params));
			$content .= ($_SESSION['level'] < 4)?$h->p("choose category ".$this->SelectUserCategories("categoryid",$dat['CATEGORYID'])):$h->p("SandBox").$h->input("hidden","categoryid",$siteDat['SANDBOXID']);
			$content .= $h->p("title").$h->p($h->input("text","title",htmlentities($dat['TITLE']),"size".FIELDWIDTH));
			$content .= $h->p("text").$h->p($h->textarea($dat['TEXT'],"text",array(12,FIELDWIDTH)));
			$content .= $h->p("wordwrap 80 cols ".$h->input("checkbox","wordwrap","1",$params));
			$content .= $h->input("hidden","userid",$_SESSION['userid']);
			$content .= $h->p($h->input("submit","save","save"));
			$result = $h->form($content,"article","post","admin.php?action=modify_article");
			return $result;
		}
	}
	public function update_articles() {
		$values = $_POST;
		foreach($values as $k=>$v) {
			if ( preg_match("/\_/",$k) ) {
				list($key,$id) = explode("_",$k);
				$formValues[$id][$key] = $v;
			}
		}
		foreach($formValues as $id=>$value) {
			$req = 0;
			if (isset($value['delete'])) {
				$req = "DELETE FROM ".ARTICLES." WHERE ID = ".$id;
				$req = $this->req($req);
			}
		}
		$result = "";
		return $result;
	}
	private function sortArticleBy() {
		$type = isset($_POST['sorttype'])?$_POST['sorttype']:1;
		switch ($type) {
			case 1:
				$result = ARTICLES.".DATE DESC";
				break;
			case 2:
				$result = ARTICLES.".TITLE";
				break;
			case 3:
				$result = ARTICLES.".CATEGORYID";
				break;
			case 3:
				$result = ARTICLES.".USERID";;
				break;
		}
		return $result;
	}
	public function list_articles($pgPos) {
		if ($pgPos) $pgPos = ($pgPos - 1) * ADMINITEMSBYPAGE;
		$h = New CodeHtml();
		$siteDat = $this->home_params();
		$reqLevel1 = 	"SELECT DISTINCT ".ARTICLES.".ID,".ARTICLES.".TITLE,".ARTICLES.".DATE,".USERS.".USERNAME,".CATEGORIES.".NAME FROM ".ARTICLES.",".USERS.",".CATEGORIES.
						" WHERE ".
						ARTICLES.".USERID = ".USERS.".ID AND ".
						ARTICLES.".CATEGORYID = ".CATEGORIES.".ID".
						" ORDER BY ".$this->sortArticleBy()." LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		$reqLevel2 = $reqLevel1;
		$reqLevel3 = 	"SELECT DISTINCT ".ARTICLES.".ID,".ARTICLES.".TITLE,".ARTICLES.".DATE,".CATEGORIES.".NAME FROM ".ARTICLES.",".CATEGORIES.
						" WHERE ".
						ARTICLES.".USERID = ".$_SESSION['userid']." AND ".
						ARTICLES.".CATEGORYID = ".CATEGORIES.".ID".
						" ORDER BY ".$this->sortArticleBy()." LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		$reqLevel4 = 	"SELECT ID,TITLE,DATE FROM ".ARTICLES." WHERE ".
						ARTICLES.".CATEGORYID = ".$siteDat['SANDBOXID']." ORDER BY ".$this->sortArticleBy()." LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		
		$reqs = array("",$reqLevel1,$reqLevel2,$reqLevel3,$reqLevel4);
		$req = $reqs[$_SESSION['level']];
		$req = $this->req($req);
		$modified = isset($_POST['update'])?", (some values have been modified !)":null;
		$result = $h->h3("articles list".$modified);
		$sort = array("date"=>1,"title"=>2,"category"=>3,"user"=>4);
		$sortForm = $h->p($h->input("submit","","sort/group by").$h->select($sort,"sorttype",2));
		$result .= $h->form($sortForm,"sort","post","admin.php?action=articles");
		$artList = $h->p($h->input("submit","","delete selected"));
		$artList .= $h->input("hidden","update",1);
		$i=1;
		while ( $line = @mysqli_fetch_assoc($req) ) {
			$user = isset($line['USERNAME'])?" {author-".$line['USERNAME']."}":null;
			$category = isset($line['NAME'])?" {category-".$line['NAME']."}":null;
			$content = $i." ";$i++;
			$content .= $h->ahref("admin.php?action=modify_article&amp;art=".$line['ID'],"modify")." , ";
			$content .= $h->ahref("index.php?art=".$line['ID'],"view","target=_blank")." , ";
			$content .= "\"".short($line['TITLE'],60)."\" {date-".$line['DATE']."}";
			$content .= $user.$category;
			$content .= " , delete ".$h->input("checkbox","delete_".$line['ID'],"on");
			$artList .= $h->p($content);
		}
		$artList .= $h->p($h->input("submit","","delete selected"));
		$result .= $h->form($artList,"articles","post","admin.php?action=articles");
		return $result;
	}
	/* user */
	public function update_user($userId) {
		$h = New CodeHtml();
		/* check is login is in use */
		//~ $req = "SELECT ID FROM ".USERS." WHERE LOGIN = '".$h->safe($_POST['userlogin'])."'";
		//~ $req = $this->req($req);
		//~ if (@mysqli_fetch_assoc($req)) return $h->h3("login in use !");
		/* create user */
		if (empty($_POST['password'])) {
			$result = $h->h3("password empty !");
		} else if ($_POST['password'] != $_POST['confirm'] || $h->num($_POST['level']) < $_SESSION['level']) {
			$result = $h->h3("wrong password or level !");
		} else if ($_POST['userlogin'] == "") {
			$result = $h->h3("login field empty !");
		} else {
			$req = "UPDATE ".USERS." SET LOGIN = '".$h->safe($_POST['userlogin'])."'".
										",USERNAME = '".$h->safe($_POST['username'])."'".
										",DESCRIPTION = '".$h->safe($_POST['description'])."'".
										",MAIL = '".$h->safe($_POST['mail'])."'".
										",LOGIN = '".$h->safe($_POST['userlogin'])."'".
										",USERLEVEL = ".$h->num($_POST['level']).
										",PASSWORD = '".$h->crypt($_POST['password'])."'".
										" WHERE ID = ".$userId;
			$req = $this->req($req);
			$result = $h->h3("user ".$_POST['username']." updated !");
		}
		return $result;
	}
	public function add_user() {
		$h = New CodeHtml();
		/* check is login is in use */
		$req = "SELECT ID FROM ".USERS." WHERE LOGIN = '".$h->safe($_POST['userlogin'])."'";
		$req = $this->req($req);
		if (@mysqli_fetch_assoc($req)) return $h->h3("login in use !");
		/* create user */
		if (empty($_POST['password'])) {
			$result = $h->h3("password empty !");
		} else if ($_POST['password'] != $_POST['confirm'] || $h->num($_POST['level']) < $_SESSION['level']) {
			$result = $h->h3("wrong password or level !");
		} else if ($_POST['userlogin'] == "") {
			$result = $h->h3("login field empty !");
		} else {
			$req = "INSERT INTO ".USERS."  (LOGIN,PASSWORD,USERNAME,MAIL,DESCRIPTION,USERLEVEL,USEROWNER) VALUES (".
											"'".$h->safe($_POST['userlogin'])."','".$h->crypt($_POST['password'])."','".
											$h->safe($_POST['username'])."','".$h->safe($_POST['mail'])."','".
											$h->safe($_POST['description'])."',".$h->num($_POST['level']).",".
											$_SESSION['userid'].")";
			$req = $this->req($req);
			$result = $h->h3("user ".$_POST['username']." created !");
		}
		return $result;
	}
	public function data_user($userId) {
		$h = New CodeHtml();
		$req = "SELECT * FROM ".USERS." WHERE ID = ".$userId.";";
		$req = $this->req($req);
		$dat = @mysqli_fetch_assoc($req);
		if ($dat['USERLEVEL'] < $_SESSION['level']) return $h->h2("error level");
		if ($_SESSION['level'] > 2 && $dat['USEROWNER'] =! $_SESSION['userid']) return $h->h2("error owner");
		$siteDat = $this->home_params();
		$content = $h->input("hidden","update",1);
		$content .= $h->input("hidden","user8",$dat['ID']);
		$content .= $h->p("login = ".$h->input("text","userlogin",$dat['LOGIN']));
		$content .= $h->p("password = ".$h->input("password","password"));
		$content .= $h->p("confirm password = ".$h->input("password","confirm"));
		$levels = array();
		for ($i=0;$i < (5 - $_SESSION['level']);$i++) {
			$x = 4 - $i;
			$levels["level ".$x] =  $x;
		}
		$content .= $h->p("level = ".$h->select($levels,"level",$dat['USERLEVEL']));
		$content .= $h->p("name ".$h->input("text","username",htmlentities($dat['USERNAME'])));
		$content .= $h->p("description").$h->p($h->textarea($dat['DESCRIPTION'],"description",array(8,FIELDWIDTH)));
		$content .= $h->p("mail = ".$h->input("text","mail",$dat['MAIL']));
		$content .= $h->p($h->input("submit","save","save"));
		$result = $h->form($content ,"user","post","admin.php?action=modify_user");
		return $result;
	}
	public function update_users() {
		$values = $_POST;
		foreach($values as $k=>$v) {
			if ( preg_match("/\_/",$k) ) {
				list($key,$id) = explode("_",$k);
				$formValues[$id][$key] = $v;
			}
		}
		foreach($formValues as $id=>$value) {
			$req = 0;
			if (isset($value['delete'])) {
				$req = "DELETE FROM ".USERS." WHERE ID = ".$id;
				$req = $this->req($req);
				$req = "DELETE FROM ".USERCATEGORIES." WHERE USERID = ".$id;
				$req = $this->req($req);
				$req = "DELETE FROM ".ARTICLES." WHERE USERID = ".$id;
				$req = $this->req($req);
				$req = "DELETE FROM ".CATEGORIES." WHERE USERID = ".$id;
				$req = $this->req($req);
			}
		}
		$result = "";
		return $result;
	}
	public function list_users($pgPos=0) {
		if ($pgPos) $pgPos = ($pgPos - 1) * ADMINITEMSBYPAGE;
		$h = New CodeHtml();
		$reqLevel1 = 	"SELECT * FROM ".USERS." ORDER BY USERNAME LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		$reqLevel2 = 	"SELECT * FROM ".USERS." WHERE USERLEVEL > 1 ORDER BY USERNAME LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		$reqLevel3 = 	"SELECT * FROM ".USERS." WHERE USEROWNER = ".$_SESSION['userid']." ORDER BY USERNAME LIMIT ".$pgPos.",".ADMINITEMSBYPAGE;
		$reqs = array("",$reqLevel1,$reqLevel2,$reqLevel3);
		$req = $this->req($reqs[$_SESSION['level']]);
		$modified = (empty($_POST))?null:", (some values have been modified !)";
		$artList = $h->h3("users list".$modified);
		$artList .= $h->p($h->input("submit","","delete selected"));
		$i = 1;
		while ( $line = @mysqli_fetch_assoc($req) ) {
			$content = $i." ";$i++;
			$content .= $h->ahref("admin.php?action=modify_user&amp;user=".$line['ID'],"modify")." , ";
			$content .= $h->ahref("index.php?user=".$line['ID'],"view","target=_blank")." , ";
			$content .= "(".$line['LOGIN'].") , ";
			$content .= "\"".strip_tags($line['USERNAME'])."\" {level-".$line['USERLEVEL']."}";
			$content .= " , delete ".$h->input("checkbox","delete_".$line['ID'],"on");
			$artList .= $h->p($content);
		}
		$artList .= $h->p($h->input("submit","","delete selected"));
		$result = $h->form($artList,"users","post","admin.php?action=users");
		return $result;
	}
	public function SelectUserCategories($name,$catId) {
		$siteDat = $this->home_params();
		$reqLevel1 = 	"SELECT ID,NAME FROM ".CATEGORIES." ORDER BY NAME";
		$reqLevel2 = 	"SELECT ".CATEGORIES.".ID,".CATEGORIES.".NAME FROM ".CATEGORIES.",".USERCATEGORIES.
						" WHERE ".USERCATEGORIES.".USERID = ".$_SESSION['userid']." AND ".
						USERCATEGORIES.".CATEGORYID = ".CATEGORIES.".ID ".
						" ORDER BY ".CATEGORIES.".NAME";
		
		$reqLevel3 = $reqLevel2;

		$reqs = array("",$reqLevel1,$reqLevel2,$reqLevel3);
		$req = $this->req($reqs[$_SESSION['level']]);
		
		$elements = array();
		while ( $line = @mysqli_fetch_assoc($req) ) {
			if ($line['ID'] == $siteDat['CATEGORYID']) {
				$elements["(home) ".$line['NAME']] = $line['ID'];
			} else {
				$elements[$line['NAME']] = $line['ID'];
			}
		}
		$elements[$this->catName($siteDat['SANDBOXID'])] = $siteDat['SANDBOXID'];
		$h = New CodeHtml();
		$result = $h->select($elements,$name,$catId);
		return $result;
	}
	public function userCategories() {
		$siteDat = $this->home_params();
		$reqLevel2 = 	"SELECT ".CATEGORIES.".ID,".CATEGORIES.".NAME FROM ".CATEGORIES.",".USERCATEGORIES.
						" WHERE ".USERCATEGORIES.".USERID = ".$_SESSION['userid']." AND ".
						USERCATEGORIES.".CATEGORYID = ".CATEGORIES.".ID ORDER BY ".CATEGORIES.".NAME";
						
		$reqLevel1 = 	"SELECT ID,NAME FROM ".CATEGORIES." ORDER BY NAME";
		
		if ($_SESSION['level'] > 1) {
			$req = $this->req($reqLevel2);
		} else {
			$req = $this->req($reqLevel1);
		}
		$elements = array();
		while ( $line = @mysqli_fetch_assoc($req) ) {
			if ($line['ID'] == $siteDat['CATEGORYID']) {
				$elements["(home) ".$line['NAME']] = $line['ID'];
			} else {
				$elements[$line['NAME']] = $line['ID'];
			}
		}
		if (count($elements)) {
			$h = New CodeHtml();
			$menu = $h->select($elements,"cat",$siteDat['CATEGORYID']).$h->input("submit",null,"GO");
			$result = $h->form("modify ".$menu,"categories","post","admin.php?action=modify_category");
			return $result;
		}
	}
}
?>
